/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.UnitOfWork;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

@Provider
public class UnitOfWorkApplicationListener
implements ApplicationEventListener {
    private Map<Method, UnitOfWork> methodMap = new HashMap<Method, UnitOfWork>();
    private Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();

    public UnitOfWorkApplicationListener() {
    }

    public UnitOfWorkApplicationListener(String name, SessionFactory sessionFactory) {
        this.registerSessionFactory(name, sessionFactory);
    }

    public void registerSessionFactory(String name, SessionFactory sessionFactory) {
        this.sessionFactories.put(name, sessionFactory);
    }

    @Override
    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            for (Resource resource : event.getResourceModel().getResources()) {
                for (ResourceMethod method : resource.getAllMethods()) {
                    this.registerUnitOfWorkAnnotations(method);
                }
                for (Resource childResource : resource.getChildResources()) {
                    for (ResourceMethod method : childResource.getAllMethods()) {
                        this.registerUnitOfWorkAnnotations(method);
                    }
                }
            }
        }
    }

    @Override
    public RequestEventListener onRequest(RequestEvent event) {
        return new UnitOfWorkEventListener(this.methodMap, this.sessionFactories);
    }

    private void registerUnitOfWorkAnnotations(ResourceMethod method) {
        UnitOfWork annotation = method.getInvocable().getDefinitionMethod().getAnnotation(UnitOfWork.class);
        if (annotation == null) {
            annotation = method.getInvocable().getHandlingMethod().getAnnotation(UnitOfWork.class);
        }
        if (annotation != null) {
            this.methodMap.put(method.getInvocable().getDefinitionMethod(), annotation);
        }
    }

    private static class UnitOfWorkEventListener
    implements RequestEventListener {
        private final Map<Method, UnitOfWork> methodMap;
        private final Map<String, SessionFactory> sessionFactories;
        private UnitOfWork unitOfWork;
        private Session session;
        private SessionFactory sessionFactory;

        public UnitOfWorkEventListener(Map<Method, UnitOfWork> methodMap, Map<String, SessionFactory> sessionFactories) {
            this.methodMap = methodMap;
            this.sessionFactories = sessionFactories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START) {
                this.unitOfWork = this.methodMap.get(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod());
                if (this.unitOfWork != null) {
                    this.sessionFactory = this.sessionFactories.get(this.unitOfWork.value());
                    if (this.sessionFactory == null) {
                        if (this.unitOfWork.value().equals("hibernate") && this.sessionFactories.size() == 1) {
                            this.sessionFactory = this.sessionFactories.values().iterator().next();
                        } else {
                            throw new IllegalArgumentException("Unregistered Hibernate bundle: '" + this.unitOfWork.value() + "'");
                        }
                    }
                    this.session = this.sessionFactory.openSession();
                    try {
                        this.configureSession();
                        ManagedSessionContext.bind(this.session);
                        this.beginTransaction();
                    }
                    catch (Throwable th) {
                        this.session.close();
                        this.session = null;
                        ManagedSessionContext.unbind(this.sessionFactory);
                        throw th;
                    }
                }
            } else if (event.getType() == RequestEvent.Type.RESP_FILTERS_START) {
                if (this.session != null) {
                    try {
                        this.commitTransaction();
                    }
                    catch (Exception e) {
                        this.rollbackTransaction();
                        throw new MappableException(e);
                    }
                    finally {
                        this.session.close();
                        this.session = null;
                        ManagedSessionContext.unbind(this.sessionFactory);
                    }
                }
            } else if (event.getType() == RequestEvent.Type.ON_EXCEPTION && this.session != null) {
                try {
                    this.rollbackTransaction();
                }
                finally {
                    this.session.close();
                    this.session = null;
                    ManagedSessionContext.unbind(this.sessionFactory);
                }
            }
        }

        private void beginTransaction() {
            if (this.unitOfWork.transactional()) {
                this.session.beginTransaction();
            }
        }

        private void configureSession() {
            this.session.setDefaultReadOnly(this.unitOfWork.readOnly());
            this.session.setCacheMode(this.unitOfWork.cacheMode());
            this.session.setFlushMode(this.unitOfWork.flushMode());
        }

        private void rollbackTransaction() {
            Transaction txn;
            if (this.unitOfWork.transactional() && (txn = this.session.getTransaction()) != null && txn.isActive()) {
                txn.rollback();
            }
        }

        private void commitTransaction() {
            Transaction txn;
            if (this.unitOfWork.transactional() && (txn = this.session.getTransaction()) != null && txn.isActive()) {
                txn.commit();
            }
        }
    }
}

