/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.util.concurrent.MoreExecutors;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SessionFactoryHealthCheck
extends HealthCheck {
    private final SessionFactory sessionFactory;
    private final String validationQuery;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public SessionFactoryHealthCheck(SessionFactory sessionFactory, String validationQuery) {
        this(MoreExecutors.newDirectExecutorService(), Duration.seconds(0L), sessionFactory, validationQuery);
    }

    public SessionFactoryHealthCheck(ExecutorService executorService, Duration duration, SessionFactory sessionFactory, String validationQuery) {
        this.sessionFactory = sessionFactory;
        this.validationQuery = validationQuery;
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(new Callable<HealthCheck.Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HealthCheck.Result call() throws Exception {
                try (Session session = SessionFactoryHealthCheck.this.sessionFactory.openSession();){
                    Transaction txn = session.beginTransaction();
                    try {
                        session.createSQLQuery(SessionFactoryHealthCheck.this.validationQuery).list();
                        txn.commit();
                    }
                    catch (Exception e) {
                        if (txn.isActive()) {
                            txn.rollback();
                        }
                        throw e;
                    }
                }
                return HealthCheck.Result.healthy();
            }
        });
    }
}

