/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.google.common.collect.Sets;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryManager;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFactoryFactory.class);
    private static final String DEFAULT_NAME = "hibernate";

    public SessionFactory build(HibernateBundle<?> bundle2, Environment environment, PooledDataSourceFactory dbConfig, List<Class<?>> entities) {
        return this.build(bundle2, environment, dbConfig, entities, DEFAULT_NAME);
    }

    public SessionFactory build(HibernateBundle<?> bundle2, Environment environment, PooledDataSourceFactory dbConfig, List<Class<?>> entities, String name) {
        ManagedDataSource dataSource = dbConfig.build(environment.metrics(), name);
        return this.build(bundle2, environment, dbConfig, dataSource, entities);
    }

    public SessionFactory build(HibernateBundle<?> bundle2, Environment environment, PooledDataSourceFactory dbConfig, ManagedDataSource dataSource, List<Class<?>> entities) {
        ConnectionProvider provider = this.buildConnectionProvider(dataSource, dbConfig.getProperties());
        SessionFactory factory = this.buildSessionFactory(bundle2, dbConfig, provider, dbConfig.getProperties(), entities);
        SessionFactoryManager managedFactory = new SessionFactoryManager(factory, dataSource);
        environment.lifecycle().manage(managedFactory);
        return factory;
    }

    private ConnectionProvider buildConnectionProvider(DataSource dataSource, Map<String, String> properties) {
        DatasourceConnectionProviderImpl connectionProvider = new DatasourceConnectionProviderImpl();
        connectionProvider.setDataSource(dataSource);
        connectionProvider.configure(properties);
        return connectionProvider;
    }

    private SessionFactory buildSessionFactory(HibernateBundle<?> bundle2, PooledDataSourceFactory dbConfig, ConnectionProvider connectionProvider, Map<String, String> properties, List<Class<?>> entities) {
        Configuration configuration = new Configuration();
        configuration.setProperty("hibernate.current_session_context_class", "managed");
        configuration.setProperty("hibernate.use_sql_comments", Boolean.toString(dbConfig.isAutoCommentsEnabled()));
        configuration.setProperty("hibernate.jdbc.use_get_generated_keys", "true");
        configuration.setProperty("hibernate.generate_statistics", "true");
        configuration.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
        configuration.setProperty("hibernate.order_updates", "true");
        configuration.setProperty("hibernate.order_inserts", "true");
        configuration.setProperty("hibernate.id.new_generator_mappings", "true");
        configuration.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
        for (Map.Entry<String, String> property : properties.entrySet()) {
            configuration.setProperty(property.getKey(), property.getValue());
        }
        this.addAnnotatedClasses(configuration, entities);
        bundle2.configure(configuration);
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().addService(ConnectionProvider.class, connectionProvider).applySettings(properties).build();
        this.configure(configuration, registry);
        return configuration.buildSessionFactory(registry);
    }

    protected void configure(Configuration configuration, ServiceRegistry registry) {
    }

    private void addAnnotatedClasses(Configuration configuration, Iterable<Class<?>> entities) {
        TreeSet<String> entityClasses = Sets.newTreeSet();
        for (Class<?> klass : entities) {
            configuration.addAnnotatedClass(klass);
            entityClasses.add(klass.getCanonicalName());
        }
        LOGGER.info("Entity classes: {}", (Object)entityClasses);
    }
}

