/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module;
import com.google.common.collect.ImmutableList;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.hibernate.SessionFactoryHealthCheck;
import io.dropwizard.hibernate.UnitOfWorkApplicationListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import org.hibernate.SessionFactory;

public abstract class HibernateBundle<T extends Configuration>
implements ConfiguredBundle<T>,
DatabaseConfiguration<T> {
    public static final String DEFAULT_NAME = "hibernate";
    private SessionFactory sessionFactory;
    private final ImmutableList<Class<?>> entities;
    private final SessionFactoryFactory sessionFactoryFactory;

    protected HibernateBundle(Class<?> entity, Class<?> ... entities) {
        this((ImmutableList<Class<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(entity)).add(entities)).build(), new SessionFactoryFactory());
    }

    protected HibernateBundle(ImmutableList<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        this.entities = entities;
        this.sessionFactoryFactory = sessionFactoryFactory;
    }

    @Override
    public final void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerModule(this.createHibernate4Module());
    }

    protected Hibernate4Module createHibernate4Module() {
        return new Hibernate4Module();
    }

    protected String name() {
        return DEFAULT_NAME;
    }

    @Override
    public final void run(T configuration, Environment environment) throws Exception {
        PooledDataSourceFactory dbConfig = this.getDataSourceFactory(configuration);
        this.sessionFactory = this.sessionFactoryFactory.build(this, environment, dbConfig, this.entities, this.name());
        this.registerUnitOfWorkListerIfAbsent(environment).registerSessionFactory(this.name(), this.sessionFactory);
        environment.healthChecks().register(this.name(), new SessionFactoryHealthCheck(environment.getHealthCheckExecutorService(), dbConfig.getValidationQueryTimeout().or(Duration.seconds(5L)), this.sessionFactory, dbConfig.getValidationQuery()));
    }

    private UnitOfWorkApplicationListener registerUnitOfWorkListerIfAbsent(Environment environment) {
        for (Object singleton : environment.jersey().getResourceConfig().getSingletons()) {
            if (!(singleton instanceof UnitOfWorkApplicationListener)) continue;
            return (UnitOfWorkApplicationListener)singleton;
        }
        UnitOfWorkApplicationListener listener = new UnitOfWorkApplicationListener();
        environment.jersey().register(listener);
        return listener;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected void configure(org.hibernate.cfg.Configuration configuration) {
    }
}

