/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.google.common.base.Preconditions;
import io.dropwizard.util.Generics;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class AbstractDAO<E> {
    private final SessionFactory sessionFactory;
    private final Class<?> entityClass;

    public AbstractDAO(SessionFactory sessionFactory) {
        this.sessionFactory = Preconditions.checkNotNull(sessionFactory);
        this.entityClass = Generics.getTypeParameter(this.getClass());
    }

    protected Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Criteria criteria() {
        return this.currentSession().createCriteria(this.entityClass);
    }

    protected Query namedQuery(String queryName) throws HibernateException {
        return this.currentSession().getNamedQuery(Preconditions.checkNotNull(queryName));
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected E uniqueResult(Criteria criteria) throws HibernateException {
        return (E)Preconditions.checkNotNull(criteria).uniqueResult();
    }

    protected E uniqueResult(Query query) throws HibernateException {
        return (E)Preconditions.checkNotNull(query).uniqueResult();
    }

    protected List<E> list(Criteria criteria) throws HibernateException {
        return Preconditions.checkNotNull(criteria).list();
    }

    protected List<E> list(Query query) throws HibernateException {
        return Preconditions.checkNotNull(query).list();
    }

    protected E get(Serializable id) {
        return (E)this.currentSession().get(this.entityClass, Preconditions.checkNotNull(id));
    }

    protected E persist(E entity) throws HibernateException {
        this.currentSession().saveOrUpdate(Preconditions.checkNotNull(entity));
        return entity;
    }

    protected <T> T initialize(T proxy) throws HibernateException {
        if (!Hibernate.isInitialized(proxy)) {
            Hibernate.initialize(proxy);
        }
        return proxy;
    }
}

