/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.text.StrSubstitutor;

public class SubstitutingSourceProvider
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider delegate;
    private final StrSubstitutor substitutor;

    public SubstitutingSourceProvider(ConfigurationSourceProvider delegate, StrSubstitutor substitutor) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.substitutor = Preconditions.checkNotNull(substitutor);
    }

    @Override
    public InputStream open(String path) throws IOException {
        String config = new String(ByteStreams.toByteArray(this.delegate.open(path)), StandardCharsets.UTF_8);
        String substituted = this.substitutor.replace(config);
        return new ByteArrayInputStream(substituted.getBytes(StandardCharsets.UTF_8));
    }
}

