/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.cli;

import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Environment;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCommand<T extends Configuration>
extends EnvironmentCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerCommand.class);
    private final Class<T> configurationClass;

    public ServerCommand(Application<T> application) {
        super(application, "server", "Runs the Dropwizard application as an HTTP server");
        this.configurationClass = application.getConfigurationClass();
    }

    @Override
    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    @Override
    protected void run(Environment environment, Namespace namespace, T configuration) throws Exception {
        Server server = ((Configuration)configuration).getServerFactory().build(environment);
        try {
            server.addLifeCycleListener(new LifeCycleListener());
            this.cleanupAsynchronously();
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start server, shutting down", e);
            server.stop();
            this.cleanup();
            throw e;
        }
    }

    private class LifeCycleListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private LifeCycleListener() {
        }

        @Override
        public void lifeCycleStopped(LifeCycle event) {
            ServerCommand.this.cleanup();
        }
    }
}

