/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.basic;

import com.google.common.base.Optional;
import com.google.common.io.BaseEncoding;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.basic.BasicCredentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class BasicCredentialAuthFilter<P extends Principal>
extends AuthFilter<BasicCredentials, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCredentialAuthFilter.class);

    private BasicCredentialAuthFilter() {
    }

    @Override
    public void filter(final ContainerRequestContext requestContext) throws IOException {
        block5: {
            String header = requestContext.getHeaders().getFirst("Authorization");
            try {
                String decoded;
                int i;
                String method;
                int space;
                if (header == null || (space = header.indexOf(32)) <= 0 || !this.prefix.equalsIgnoreCase(method = header.substring(0, space)) || (i = (decoded = new String(BaseEncoding.base64().decode(header.substring(space + 1)), StandardCharsets.UTF_8)).indexOf(58)) <= 0) break block5;
                String username = decoded.substring(0, i);
                String password = decoded.substring(i + 1);
                BasicCredentials credentials = new BasicCredentials(username, password);
                try {
                    final Optional principal = this.authenticator.authenticate(credentials);
                    if (principal.isPresent()) {
                        requestContext.setSecurityContext(new SecurityContext(){

                            @Override
                            public Principal getUserPrincipal() {
                                return (Principal)principal.get();
                            }

                            @Override
                            public boolean isUserInRole(String role) {
                                return BasicCredentialAuthFilter.this.authorizer.authorize((Principal)principal.get(), role);
                            }

                            @Override
                            public boolean isSecure() {
                                return requestContext.getSecurityContext().isSecure();
                            }

                            @Override
                            public String getAuthenticationScheme() {
                                return "BASIC";
                            }
                        });
                        return;
                    }
                }
                catch (AuthenticationException e) {
                    LOGGER.warn("Error authenticating credentials", e);
                    throw new InternalServerErrorException();
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Error decoding credentials", e);
            }
        }
        throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<BasicCredentials, P, BasicCredentialAuthFilter<P>> {
        @Override
        protected BasicCredentialAuthFilter<P> newInstance() {
            return new BasicCredentialAuthFilter();
        }
    }
}

