/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.functions;

import com.github.mustachejava.TemplateFunction;
import com.google.common.base.Function;
import java.util.Locale;
import java.util.ResourceBundle;

public class BundleFunctions {
    public static Function newPreTranslate(String bundle2, Locale locale) {
        return new PreTranslateFunc(bundle2, locale, true);
    }

    public static Function newPreTranslateNullableLabel(String bundle2, Locale locale) {
        return new PreTranslateFunc(bundle2, locale, false);
    }

    public static Function newPostTranslate(String bundle2, Locale locale) {
        return new PostTranslateFunc(bundle2, locale, true);
    }

    public static Function newPostTranslateNullableLabel(String bundle2, Locale locale) {
        return new PostTranslateFunc(bundle2, locale, false);
    }

    static class PostTranslateFunc
    extends BundleFunc
    implements Function {
        private PostTranslateFunc(String bundle2, Locale locale, boolean returnLabels) {
            super(bundle2, locale, returnLabels);
        }

        public Object apply(Object input) {
            return super.lookup((String)input);
        }
    }

    static class PreTranslateFunc
    extends BundleFunc
    implements TemplateFunction {
        private PreTranslateFunc(String bundle2, Locale locale, boolean returnLabels) {
            super(bundle2, locale, returnLabels);
        }

        @Override
        public String apply(String input) {
            return super.lookup(input);
        }
    }

    private static abstract class BundleFunc {
        protected final ResourceBundle res;
        protected final boolean returnLabels;

        protected BundleFunc(String bundle2, Locale locale, boolean returnLabels) {
            this.res = ResourceBundle.getBundle(bundle2, locale);
            this.returnLabels = returnLabels;
        }

        protected final String lookup(String key) {
            if (this.res.containsKey(key)) {
                return this.res.getString(key);
            }
            return this.returnLabels ? key : null;
        }
    }
}

