/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common.params;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxd.common.params.EmptyParams;
import org.xdi.oxd.common.params.GetClientTokenParams;
import org.xdi.oxd.common.params.GetRpParams;
import org.xdi.oxd.common.params.HasOxdIdParams;
import org.xdi.oxd.common.params.HasProtectionAccessTokenParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.LicenseStatusParams;

public class ParamsSecurityTest {
    private static final String PARAMS_PACKAGE = "org.xdi.oxd.common.params";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final List<Class> EXCLUSING_LIST = Arrays.asList(GetClientTokenParams.class, GetRpParams.class, EmptyParams.class, HasOxdIdParams.class, HasProtectionAccessTokenParams.class, LicenseStatusParams.class, IParams.class);

    @Test
    public void checkParamsImplementsHasProtectionAccessTokenInterface() throws IOException {
        for (Class clazz : this.getAllParamsClasses()) {
            if (!EXCLUSING_LIST.contains(clazz) && !HasProtectionAccessTokenParams.class.isAssignableFrom(clazz)) {
                throw new AssertionError((Object)("Params class does not implement HasProtectionAccessTokenParams interface, class: " + clazz));
            }
        }
    }

    private Set<Class> getAllParamsClasses() throws IOException {
        URL packageResource = Thread.currentThread().getContextClassLoader().getResource(StringUtils.replace((String)PARAMS_PACKAGE, (String)".", (String)"/"));
        File packageFile = new File(StringUtils.replace((String)packageResource.getFile(), (String)"test-classes", (String)"classes"));
        Assert.assertTrue((boolean)packageFile.exists());
        Assert.assertTrue((boolean)packageFile.isDirectory());
        File[] classFiles = packageFile.listFiles();
        HashSet<Class> classes = new HashSet<Class>();
        for (File file : classFiles) {
            String resource = "org.xdi.oxd.common.params." + file.getName();
            int endIndex = resource.length() - CLASS_FILE_SUFFIX.length();
            String className = resource.substring(0, endIndex);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }
}

