/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common;

import java.io.Serializable;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.ErrorResponseCode;
import org.xdi.oxd.common.response.IOpResponse;

public class ErrorResponse
implements Serializable,
IOpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResponse.class);
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="error_description")
    private String errorDescription;
    @JsonProperty(value="details")
    private JsonNode details;

    public ErrorResponse() {
    }

    public ErrorResponse(String error) {
        this.error = error;
    }

    public ErrorResponse(ErrorResponseCode code) {
        this.error = code.getCode();
        this.errorDescription = code.getDescription();
    }

    public ErrorResponse(String error, String errorDescription) {
        this.error = error;
        this.errorDescription = errorDescription;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public JsonNode getDetails() {
        return this.details;
    }

    public void setDetails(JsonNode details) {
        this.details = details;
    }

    public <T> T detailsAs(Class<T> p_class) {
        if (this.details != null && p_class != null) {
            String asString = this.details.toString();
            try {
                return (T)CoreUtils.createJsonMapper().readValue(asString, p_class);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                LOG.error("Unable to parse string to response, string: {}", (Object)asString);
            }
        }
        return null;
    }

    public String toString() {
        return "ErrorResponse{error='" + this.error + '\'' + ", errorDescription='" + this.errorDescription + '\'' + ", details=" + this.details + '}';
    }
}

