/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.ReadResult;

public class CoreUtils {
    public static final String UTF8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);
    public static final int COMMAND_STR_LENGTH_SIZE = 4;
    public static final int BUFFER_SIZE = 8192;

    public static boolean isExpired(Date expiredAt) {
        return expiredAt.before(new Date());
    }

    private CoreUtils() {
    }

    public static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(CoreUtils.daemonThreadFactory());
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable p_r) {
                Thread thread = new Thread(p_r);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static void sleep(int i) {
        try {
            Thread.sleep(i * 1000);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = CoreUtils.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static String asJsonSilently(Object p_object) {
        try {
            ObjectMapper mapper = CoreUtils.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
            return mapper.writeValueAsString(p_object);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize object into json.", (Throwable)e);
            return "";
        }
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static Command asCommand(String commandAsJson) throws IOException {
        return (Command)CoreUtils.createJsonMapper().readValue(commandAsJson, Command.class);
    }

    public static long parseSilently(String p_str) {
        try {
            return Long.parseLong(p_str);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String normalizeLengthPrefixString(int p_length) {
        if (p_length <= 0) {
            throw new IllegalArgumentException("Length must be more than zero.");
        }
        String s = Integer.toString(p_length);
        StringBuilder sb = new StringBuilder(s);
        int sbLength = sb.length();
        if (sbLength < 4) {
            for (int i = sbLength; i < 4; ++i) {
                sb.insert(0, '0');
            }
        }
        if (sb.length() != 4) {
            throw new IllegalArgumentException("Normalized length size must be exactly: 4");
        }
        return sb.toString();
    }

    public static ReadResult readCommand(String p_leftString, BufferedReader p_reader) throws IOException {
        int totalSize;
        int storageLength;
        int commandSize = -1;
        StringBuilder storage = new StringBuilder(p_leftString != null ? p_leftString : "");
        do {
            LOG.trace("commandSize: {}, stringStorage: {}", (Object)commandSize, (Object)storage.toString());
            char[] buffer = new char[8192];
            int readCount = p_reader.read(buffer, 0, 8192);
            if (readCount == -1) {
                LOG.trace("End of stream. Quit.");
                return null;
            }
            storage.append(buffer, 0, readCount);
            storageLength = storage.length();
            if (commandSize == -1 && storageLength >= 4) {
                String sizeString = storage.substring(0, 4);
                commandSize = (int)CoreUtils.parseSilently(sizeString);
                LOG.trace("Parsed sizeString: {}, commandSize: {}", (Object)sizeString, (Object)commandSize);
                if (commandSize == -1) {
                    LOG.trace("Unable to identify command size. Quit.");
                    return null;
                }
            }
            totalSize = commandSize + 4;
        } while (commandSize == -1 || storageLength < totalSize);
        String commandAsString = storage.substring(4, totalSize);
        String leftString = "";
        if (storageLength > totalSize + 1) {
            storage.substring(totalSize + 1);
        }
        ReadResult result = new ReadResult(commandAsString, leftString);
        LOG.trace("Read result: {}", (Object)result);
        return result;
    }

    public static boolean allNotBlank(String ... p_strings) {
        if (p_strings != null && p_strings.length > 0) {
            for (String s : p_strings) {
                if (!StringUtils.isBlank((String)s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient createHttpClientWithKeyStore(File pathToKeyStore, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(pathToKeyStore);){
            keyStore.load(instream, password.toCharArray());
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        SSLSocketFactory socketFactory = new SSLSocketFactory(keyStore);
        socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)socketFactory, 443));
        httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        return httpClient;
    }

    public static HttpClient createHttpClientTrustAll() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }, new X509HostnameVerifier(){

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }

            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }

    public static String secureRandomString() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    public static Map<String, String> splitQuery(String url) throws UnsupportedEncodingException, MalformedURLException {
        return CoreUtils.splitQuery(new URL(url));
    }

    public static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), UTF8), URLDecoder.decode(pair.substring(idx + 1), UTF8));
        }
        return queryPairs;
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jackson);
            SerializationConfig serializationConfig = mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

