/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.testng.annotations.Test;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.CoreUtils;

public class JsonTest {
    @Test
    public void testCommandType() throws IOException {
        String json = CoreUtils.asJson((Object)CommandType.GET_AUTHORIZATION_URL);
        Assert.assertEquals((String)json, (String)"\"obtain_pat\"");
        CommandType obtainPat = (CommandType)CoreUtils.createJsonMapper().readValue(json, CommandType.class);
        Assert.assertNotNull((Object)obtainPat);
    }

    @Test
    public void testCommand() throws IOException {
        Command c = new Command();
        c.setCommandType(CommandType.GET_USER_INFO);
        c.setParams((JsonNode)JsonNodeFactory.instance.textNode("myParams"));
        String cJson = CoreUtils.asJson((Object)c);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)cJson));
        String json = "{\"command\":\"register_client\",\"params\": {\"discovery_url\":\"<discovery url>\",\n        \"redirect_url\":\"<redirect url>\",\n        \"client_name\":\"<client name>\"\n    }\n}";
        Command command = (Command)CoreUtils.createJsonMapper().readValue("{\"command\":\"register_client\",\"params\": {\"discovery_url\":\"<discovery url>\",\n        \"redirect_url\":\"<redirect url>\",\n        \"client_name\":\"<client name>\"\n    }\n}", Command.class);
        Assert.assertNotNull((Object)command);
    }

    @Test
    public void testErrorResponseJson() throws IOException {
        CommandResponse response = CommandResponse.createInternalError();
        String json = CoreUtils.asJson((Object)response);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)json));
    }
}

