/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.common.ReadResult;

public class CoreUtils {
    public static final String UTF8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);
    public static final int COMMAND_STR_LENGTH_SIZE = 4;
    public static final int BUFFER_SIZE = 8192;

    private CoreUtils() {
    }

    public static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable p_r) {
                Thread thread = new Thread(p_r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static void sleep(int i) {
        try {
            Thread.sleep(i * 1000);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = CoreUtils.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static long parseSilently(String p_str) {
        try {
            return Long.parseLong(p_str);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String normalizeLengthPrefixString(int p_length) {
        if (p_length <= 0) {
            throw new IllegalArgumentException("Length must be more than zero.");
        }
        String s = Integer.toString(p_length);
        StringBuilder sb = new StringBuilder(s);
        int sbLength = sb.length();
        if (sbLength < 4) {
            for (int i = sbLength; i < 4; ++i) {
                sb.insert(0, '0');
            }
        }
        if (sb.length() != 4) {
            throw new IllegalArgumentException("Normalized length size must be exactly: 4");
        }
        return sb.toString();
    }

    public static ReadResult readCommand(String p_leftString, BufferedReader p_reader) throws IOException {
        int totalSize;
        int storageLength;
        int commandSize = -1;
        StringBuilder storage = new StringBuilder(p_leftString != null ? p_leftString : "");
        do {
            LOG.trace("commandSize: {}, stringStorage: {}", (Object)commandSize, (Object)storage.toString());
            char[] buffer = new char[8192];
            int readCount = p_reader.read(buffer, 0, 8192);
            if (readCount == -1) {
                LOG.trace("End of stream. Quit.");
                return null;
            }
            storage.append(buffer, 0, readCount);
            storageLength = storage.length();
            if (commandSize == -1 && storageLength >= 4) {
                String sizeString = storage.substring(0, 4);
                commandSize = (int)CoreUtils.parseSilently(sizeString);
                LOG.trace("Parsed sizeString: {}, commandSize: {}", (Object)sizeString, (Object)commandSize);
                if (commandSize == -1) {
                    LOG.trace("Unable to identify command size. Quit.");
                    return null;
                }
            }
            totalSize = commandSize + 4;
        } while (commandSize == -1 || storageLength < totalSize);
        String commandAsString = storage.substring(4, totalSize);
        String leftString = "";
        if (storageLength > totalSize + 1) {
            storage.substring(totalSize + 1);
        }
        ReadResult result = new ReadResult(commandAsString, leftString);
        LOG.trace("Read result: {}", (Object)result);
        return result;
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jackson);
            SerializationConfig serializationConfig = mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

