/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.common;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.node.POJONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.ErrorResponseCode;
import org.xdi.oxd.common.ResponseError;
import org.xdi.oxd.common.ResponseStatus;
import org.xdi.oxd.common.response.IOpResponse;

@JsonPropertyOrder(value={"status", "data"})
public class CommandResponse {
    private static final Logger LOG = LoggerFactory.getLogger(CommandResponse.class);
    public static final CommandResponse INTERNAL_ERROR_RESPONSE = CommandResponse.createInternalError();
    public static final String INTERNAL_ERROR_RESPONSE_AS_STRING = CommandResponse.createInternalErrorAsString();
    public static final CommandResponse OPERATION_IS_NOT_SUPPORTED = CommandResponse.createUnsupportedOperationError();
    @JsonProperty(value="status")
    private ResponseStatus status;
    @JsonProperty(value="data")
    private JsonNode data;

    public CommandResponse() {
    }

    public CommandResponse(ResponseStatus p_status) {
        this.status = p_status;
    }

    public CommandResponse(ResponseStatus p_status, JsonNode p_data) {
        this.status = p_status;
        this.data = p_data;
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public CommandResponse setStatus(ResponseStatus p_status) {
        this.status = p_status;
        return this;
    }

    public JsonNode getData() {
        return this.data;
    }

    public CommandResponse setData(JsonNode p_data) {
        this.data = p_data;
        return this;
    }

    public <T extends IOpResponse> T dataAsResponse(Class<T> p_class) {
        if (this.data != null && p_class != null) {
            String asString = this.data.toString();
            try {
                return (T)((IOpResponse)CoreUtils.createJsonMapper().readValue(asString, p_class));
            }
            catch (JsonMappingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (JsonParseException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            LOG.error("Unable to parse string to response, string: {}", (Object)asString);
        }
        return null;
    }

    public static CommandResponse ok() {
        return new CommandResponse(ResponseStatus.OK);
    }

    public static CommandResponse error() {
        return new CommandResponse(ResponseStatus.ERROR);
    }

    public static CommandResponse createErrorResponse(ResponseError p_error) {
        return CommandResponse.error().setData((JsonNode)new POJONode((Object)p_error));
    }

    public static CommandResponse createErrorResponse(ErrorResponseCode p_errorCode) {
        ResponseError error = new ResponseError(p_errorCode);
        error.setErrorDescription(p_errorCode.getDescription());
        return CommandResponse.error().setData((JsonNode)new POJONode((Object)error));
    }

    public static CommandResponse createInternalError() {
        return CommandResponse.createErrorResponse(ErrorResponseCode.INTERNAL_ERROR);
    }

    public static CommandResponse createUnsupportedOperationError() {
        return CommandResponse.createErrorResponse(ErrorResponseCode.UNSUPPORTED_OPERATION);
    }

    private static String createInternalErrorAsString() {
        CommandResponse response = CommandResponse.createInternalError();
        try {
            return CoreUtils.asJson(response);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandResponse");
        sb.append("{status=").append((Object)this.status);
        sb.append(", params=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

