/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import junit.framework.Assert;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientUtils;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.uma.CreateRptService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.UmaConfiguration;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.ObtainAatParams;
import org.xdi.oxd.common.params.ObtainPatParams;
import org.xdi.oxd.common.params.RegisterPermissionTicketParams;
import org.xdi.oxd.common.params.RegisterResourceParams;
import org.xdi.oxd.common.response.ObtainAatOpResponse;
import org.xdi.oxd.common.response.ObtainPatOpResponse;
import org.xdi.oxd.common.response.RegisterPermissionTicketOpResponse;
import org.xdi.oxd.common.response.RegisterResourceOpResponse;

public class TestUtils {
    private TestUtils() {
    }

    public static TokenResponse obtainAccessToken(String userId, String userSecret, String clientId, String clientSecret, String redirectUrl, String p_authorizationEndpoint, String p_tokenEndpoint) {
        try {
            ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
            responseTypes.add(ResponseType.CODE);
            responseTypes.add(ResponseType.ID_TOKEN);
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("openid");
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUrl, null);
            request.setState("af0ifjsldkj");
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            request.setNonce(UUID.randomUUID().toString());
            request.setMaxAge(Integer.valueOf(Integer.MAX_VALUE));
            AuthorizeClient authorizeClient = new AuthorizeClient(p_authorizationEndpoint);
            authorizeClient.setRequest(request);
            ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor(CoreUtils.createHttpClientTrustAll());
            AuthorizationResponse response1 = authorizeClient.exec((ClientExecutor)clientExecutor);
            ClientUtils.showClient((BaseClient)authorizeClient);
            String scope = response1.getScope();
            String authorizationCode = response1.getCode();
            if (Util.allNotBlank((String[])new String[]{authorizationCode})) {
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(authorizationCode);
                tokenRequest.setRedirectUri(redirectUrl);
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
                tokenRequest.setScope(scope);
                TokenClient tokenClient1 = new TokenClient(p_tokenEndpoint);
                tokenClient1.setExecutor((ClientExecutor)clientExecutor);
                tokenClient1.setRequest(tokenRequest);
                TokenResponse response2 = tokenClient1.exec();
                ClientUtils.showClient((BaseClient)authorizeClient);
                if (response2.getStatus() == 200) {
                    return response2;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    public static String obtainRpt(String p_aat, String p_umaDiscoveryUrl, String p_amHost) {
        org.testng.Assert.assertNotNull((Object)p_aat);
        UmaConfiguration discovery = UmaClientFactory.instance().createMetaDataConfigurationService(p_umaDiscoveryUrl).getMetadataConfiguration();
        CreateRptService requesterPermissionTokenService = UmaClientFactory.instance().createRequesterPermissionTokenService(discovery);
        RPTResponse rptResponse = null;
        try {
            rptResponse = requesterPermissionTokenService.createRPT("Bearer " + p_aat, p_amHost);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        org.testng.Assert.assertNotNull((Object)rptResponse);
        return rptResponse.getRpt();
    }

    public static ObtainPatOpResponse obtainPat(CommandClient p_commandClient, String p_discoveryUrl, String p_umaDiscoveryUrl, String p_redirectUrl, String p_clientId, String p_clientSecret) {
        return TestUtils.obtainPat(p_commandClient, p_discoveryUrl, p_umaDiscoveryUrl, p_redirectUrl, p_clientId, p_clientSecret, "", "");
    }

    public static ObtainPatOpResponse obtainPat(CommandClient p_commandClient, String p_discoveryUrl, String p_umaDiscoveryUrl, String p_redirectUrl, String p_clientId, String p_clientSecret, String p_userId, String p_userSecret) {
        ObtainPatParams params = new ObtainPatParams();
        params.setDiscoveryUrl(p_discoveryUrl);
        params.setUmaDiscoveryUrl(p_umaDiscoveryUrl);
        params.setRedirectUrl(p_redirectUrl);
        params.setClientId(p_clientId);
        params.setClientSecret(p_clientSecret);
        params.setUserId(p_userId);
        params.setUserSecret(p_userSecret);
        Command command = new Command(CommandType.OBTAIN_PAT);
        command.setParamsObject((IParams)params);
        CommandResponse response = p_commandClient.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        return (ObtainPatOpResponse)response.dataAsResponse(ObtainPatOpResponse.class);
    }

    public static ObtainAatOpResponse obtainAat(CommandClient p_commandClient, String p_discoveryUrl, String p_umaDiscoveryUrl, String p_redirectUrl, String p_clientId, String p_clientSecret, String p_userId, String p_userSecret) {
        ObtainAatParams params = new ObtainAatParams();
        params.setDiscoveryUrl(p_discoveryUrl);
        params.setUmaDiscoveryUrl(p_umaDiscoveryUrl);
        params.setRedirectUrl(p_redirectUrl);
        params.setClientId(p_clientId);
        params.setClientSecret(p_clientSecret);
        params.setUserId(p_userId);
        params.setUserSecret(p_userSecret);
        Command command = new Command(CommandType.OBTAIN_AAT);
        command.setParamsObject((IParams)params);
        CommandResponse response = p_commandClient.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        return (ObtainAatOpResponse)response.dataAsResponse(ObtainAatOpResponse.class);
    }

    public static RegisterResourceOpResponse registerResource(CommandClient p_client, String umaDiscoveryUrl, String patToken, List<String> p_scopes) {
        RegisterResourceParams params = new RegisterResourceParams();
        params.setUmaDiscoveryUrl(umaDiscoveryUrl);
        params.setPatToken(patToken);
        params.setName("oxd test resource");
        params.setScopes(p_scopes);
        Command command = new Command(CommandType.REGISTER_RESOURCE);
        command.setParamsObject((IParams)params);
        CommandResponse response = p_client.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        RegisterResourceOpResponse r = (RegisterResourceOpResponse)response.dataAsResponse(RegisterResourceOpResponse.class);
        Assert.assertNotNull((Object)r);
        return r;
    }

    public static RegisterPermissionTicketOpResponse registerTicket(CommandClient p_client, String umaDiscoveryUrl, String patToken, String resourceId, String amHost, String rsHost, List<String> p_scopes, String requestHttpMethod, String requestUrl) {
        RegisterPermissionTicketParams params = new RegisterPermissionTicketParams();
        params.setUmaDiscoveryUrl(umaDiscoveryUrl);
        params.setPatToken(patToken);
        params.setAmHost(amHost);
        params.setRsHost(rsHost);
        params.setResourceSetId(resourceId);
        params.setScopes(p_scopes);
        params.setRequestHttpMethod(requestHttpMethod);
        params.setRequestUrl(requestUrl);
        Command command = new Command(CommandType.REGISTER_TICKET);
        command.setParamsObject((IParams)params);
        CommandResponse response = p_client.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        RegisterPermissionTicketOpResponse r = (RegisterPermissionTicketOpResponse)response.dataAsResponse(RegisterPermissionTicketOpResponse.class);
        Assert.assertNotNull((Object)r);
        return r;
    }
}

