/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.RptStatusParams;
import org.xdi.oxd.common.response.ObtainAatOpResponse;
import org.xdi.oxd.common.response.ObtainPatOpResponse;
import org.xdi.oxd.common.response.RegisterResourceOpResponse;
import org.xdi.oxd.common.response.RptStatusOpResponse;

public class RptStatusTest {
    private static final List<String> SCOPES = Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all");
    private static CommandClient g_client = null;
    private static String g_patToken;
    private static String g_aatToken;
    private static String g_rpt;
    private static String g_umaDiscoveryUrl;
    private static RegisterResourceOpResponse g_resource;

    @Parameters(value={"host", "port", "discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret", "amHost"})
    @BeforeClass
    public static void setUp(String host, int port, String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret, String amHost) throws IOException {
        g_client = new CommandClient(host, port);
        g_umaDiscoveryUrl = umaDiscoveryUrl;
        ObtainPatOpResponse patResponse = TestUtils.obtainPat(g_client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret, userId, userSecret);
        Assert.assertNotNull((Object)patResponse);
        g_patToken = patResponse.getPatToken();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)g_patToken));
        ObtainAatOpResponse aatResponse = TestUtils.obtainAat(g_client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret, userId, userSecret);
        Assert.assertNotNull((Object)aatResponse);
        g_aatToken = aatResponse.getAatToken();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)g_aatToken));
        g_resource = TestUtils.registerResource(g_client, umaDiscoveryUrl, g_patToken, SCOPES);
        Assert.assertNotNull((Object)g_resource);
        g_rpt = TestUtils.obtainRpt(g_aatToken, umaDiscoveryUrl, amHost);
        Assert.assertNotNull((Object)StringUtils.isNotBlank((String)g_rpt));
    }

    @AfterClass
    public static void tearDown() {
        CommandClient.closeQuietly((CommandClient)g_client);
    }

    @Test
    public void test() throws IOException {
        RptStatusParams params = new RptStatusParams();
        params.setPatToken(g_patToken);
        params.setRpt(g_rpt);
        params.setUmaDiscoveryUrl(g_umaDiscoveryUrl);
        Command command = new Command(CommandType.RPT_STATUS);
        command.setParamsObject((IParams)params);
        CommandResponse response = g_client.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        RptStatusOpResponse r = (RptStatusOpResponse)response.dataAsResponse(RptStatusOpResponse.class);
        Assert.assertNotNull((Object)r);
    }
}

