/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.ObtainRptParams;
import org.xdi.oxd.common.response.ObtainAatOpResponse;
import org.xdi.oxd.common.response.ObtainRptOpResponse;

public class ObtainRptTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"host", "port", "discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret", "amHost"})
    @Test
    public void test(String host, int port, String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret, String amHost) throws IOException {
        CommandClient client = null;
        try {
            client = new CommandClient(host, port);
            ObtainAatOpResponse r = TestUtils.obtainAat(client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret, userId, userSecret);
            Assert.assertNotNull((Object)r);
            String aatToken = r.getAatToken();
            ObtainRptParams params = new ObtainRptParams();
            params.setAat(aatToken);
            params.setAmHost(amHost);
            Command command = new Command(CommandType.OBTAIN_RPT);
            command.setParamsObject((IParams)params);
            CommandResponse response = client.send(command);
            Assert.assertNotNull((Object)response);
            System.out.println(response);
            ObtainRptOpResponse rptResponse = (ObtainRptOpResponse)response.dataAsResponse(ObtainRptOpResponse.class);
            Assert.assertNotNull((Object)rptResponse);
            Assert.assertTrue((boolean)StringUtils.isNotBlank((String)rptResponse.getRptToken()));
        }
        catch (Throwable throwable) {
            CommandClient.closeQuietly(client);
            throw throwable;
        }
        CommandClient.closeQuietly((CommandClient)client);
    }
}

