/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.RegisterClientParams;
import org.xdi.oxd.common.response.ObtainPatOpResponse;
import org.xdi.oxd.common.response.RegisterClientOpResponse;

public class CompleteFlowTest {
    private static CommandClient g_client;

    @Parameters(value={"host", "port"})
    @BeforeClass
    public static void beforeClass(String host, int port) throws IOException {
        g_client = new CommandClient(host, port);
    }

    @AfterClass
    public static void afterClass() {
        CommandClient.closeQuietly((CommandClient)g_client);
    }

    @Parameters(value={"discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientName"})
    @Test
    public void test(String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientName) throws IOException {
        RegisterClientOpResponse r = this.registerClient(discoveryUrl, redirectUrl, clientName);
        Assert.assertNotNull((Object)r);
        String clientId = r.getClientId();
        String clientSecret = r.getClientSecret();
        ObtainPatOpResponse patResponse = TestUtils.obtainPat(g_client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret);
        Assert.assertNotNull((Object)patResponse);
        Assert.assertNotNull((Object)patResponse.getPatToken());
        String patToken = patResponse.getPatToken();
        List<String> scopes = Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all");
        TestUtils.registerResource(g_client, umaDiscoveryUrl, patToken, scopes);
    }

    public RegisterClientOpResponse registerClient(String discoveryUrl, String redirectUrl, String clientName) {
        RegisterClientParams params = new RegisterClientParams();
        params.setDiscoveryUrl(discoveryUrl);
        params.setRedirectUrl(redirectUrl);
        params.setClientName(clientName);
        Command command = new Command(CommandType.REGISTER_CLIENT);
        command.setParamsObject((IParams)params);
        CommandResponse response = g_client.send(command);
        Assert.assertNotNull((Object)response);
        System.out.println(response);
        RegisterClientOpResponse r = (RegisterClientOpResponse)response.dataAsResponse(RegisterClientOpResponse.class);
        Assert.assertNotNull((Object)r);
        return r;
    }
}

