/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import junit.framework.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.ClientReadParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.RegisterClientParams;
import org.xdi.oxd.common.response.RegisterClientOpResponse;

public class ClientReadTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"host", "port", "discoveryUrl", "redirectUrl", "clientName"})
    @Test
    public void clientRead(String host, int port, String discoveryUrl, String redirectUrl, String clientName) throws IOException {
        CommandClient client = null;
        try {
            client = new CommandClient(host, port);
            RegisterClientParams params = new RegisterClientParams();
            params.setDiscoveryUrl(discoveryUrl);
            params.setRedirectUrl(redirectUrl);
            params.setClientName(clientName);
            Command command = new Command(CommandType.REGISTER_CLIENT);
            command.setParamsObject((IParams)params);
            CommandResponse response = client.send(command);
            Assert.assertNotNull((Object)response);
            System.out.println(response);
            RegisterClientOpResponse r = (RegisterClientOpResponse)response.dataAsResponse(RegisterClientOpResponse.class);
            Assert.assertNotNull((Object)r);
            Assert.assertNotNull((Object)r.getRegistrationClientUri());
            ClientReadParams clientReadParams = new ClientReadParams();
            clientReadParams.setRegistrationAccessToken(r.getRegistrationAccessToken());
            clientReadParams.setRegistrationClientUri(r.getRegistrationClientUri());
            Command clientReadCommand = new Command(CommandType.CLIENT_READ);
            clientReadCommand.setParamsObject((IParams)clientReadParams);
            CommandResponse clientReadResponse = client.send(clientReadCommand);
            Assert.assertNotNull((Object)clientReadResponse);
            System.out.println(clientReadResponse);
            RegisterClientOpResponse readR = (RegisterClientOpResponse)clientReadResponse.dataAsResponse(RegisterClientOpResponse.class);
            Assert.assertNotNull((Object)readR);
            Assert.assertNotNull((Object)readR.getRegistrationClientUri());
            Assert.assertTrue((boolean)readR.getClientId().equals(r.getClientId()));
        }
        catch (Throwable throwable) {
            CommandClient.closeQuietly(client);
            throw throwable;
        }
        CommandClient.closeQuietly((CommandClient)client);
    }
}

