/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.CheckIdTokenParams;
import org.xdi.oxd.common.params.DiscoveryParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.response.CheckIdTokenResponse;

public class CheckIdTokenTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"host", "port", "discoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret"})
    @Test
    public void test(String host, int port, String discoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret) throws IOException {
        CommandClient client = null;
        try {
            client = new CommandClient(host, port);
            Command command = new Command(CommandType.DISCOVERY);
            command.setParamsObject((IParams)new DiscoveryParams(discoveryUrl));
            CommandResponse response = client.send(command);
            Assert.assertNotNull((Object)response);
            String authorizationEndpoint = response.getData().get("authorization_endpoint").asText();
            String tokenEndpoint = response.getData().get("token_endpoint").asText();
            TokenResponse tokenResponse = TestUtils.obtainAccessToken(userId, userSecret, clientId, clientSecret, redirectUrl, authorizationEndpoint, tokenEndpoint);
            CheckIdTokenParams params = new CheckIdTokenParams();
            params.setDiscoveryUrl(discoveryUrl);
            params.setIdToken(tokenResponse.getIdToken());
            Command checkIdTokenCommand = new Command(CommandType.CHECK_ID_TOKEN);
            checkIdTokenCommand.setParamsObject((IParams)params);
            CommandResponse r = client.send(checkIdTokenCommand);
            Assert.assertNotNull((Object)r);
            CheckIdTokenResponse checkR = (CheckIdTokenResponse)r.dataAsResponse(CheckIdTokenResponse.class);
            Assert.assertNotNull((Object)checkR);
            Assert.assertTrue((boolean)checkR.isActive());
            Assert.assertNotNull((Object)checkR.getExpiresAt());
            Assert.assertNotNull((Object)checkR.getIssuedAt());
            Assert.assertNotNull((Object)checkR.getClaims());
            Map claims = checkR.getClaims();
            CheckIdTokenTest.assertClaim(claims, "aud");
            CheckIdTokenTest.assertClaim(claims, "iss");
        }
        catch (Throwable throwable) {
            CommandClient.closeQuietly(client);
            throw throwable;
        }
        CommandClient.closeQuietly((CommandClient)client);
    }

    public static void assertClaim(Map<String, List<String>> p_claims, String p_claimName) {
        List<String> claimValueList = p_claims.get(p_claimName);
        Assert.assertTrue((claimValueList != null && !claimValueList.isEmpty() ? 1 : 0) != 0);
    }
}

