/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import junit.framework.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.CheckAccessTokenParams;
import org.xdi.oxd.common.params.DiscoveryParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.response.CheckAccessTokenResponse;

public class CheckAccessTokenTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"host", "port", "discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret"})
    @Test
    public void test(String host, int port, String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret) throws IOException {
        CommandClient client = null;
        try {
            client = new CommandClient(host, port);
            Command command = new Command(CommandType.DISCOVERY);
            command.setParamsObject((IParams)new DiscoveryParams(discoveryUrl));
            CommandResponse response = client.send(command);
            Assert.assertNotNull((Object)response);
            String authorizationEndpoint = response.getData().get("authorization_endpoint").asText();
            String tokenEndpoint = response.getData().get("token_endpoint").asText();
            TokenResponse tokenResponse = TestUtils.obtainAccessToken(userId, userSecret, clientId, clientSecret, redirectUrl, authorizationEndpoint, tokenEndpoint);
            CheckAccessTokenParams params = new CheckAccessTokenParams();
            params.setDiscoveryUrl(discoveryUrl);
            params.setAccessToken(tokenResponse.getAccessToken());
            params.setIdToken(tokenResponse.getIdToken());
            Command checkIdTokenCommand = new Command(CommandType.CHECK_ACCESS_TOKEN);
            checkIdTokenCommand.setParamsObject((IParams)params);
            CommandResponse r = client.send(checkIdTokenCommand);
            Assert.assertNotNull((Object)r);
            CheckAccessTokenResponse checkR = (CheckAccessTokenResponse)r.dataAsResponse(CheckAccessTokenResponse.class);
            Assert.assertNotNull((Object)checkR);
            Assert.assertTrue((boolean)checkR.isActive());
            Assert.assertNotNull((Object)checkR.getExpiresAt());
            Assert.assertNotNull((Object)checkR.getIssuedAt());
        }
        catch (Throwable throwable) {
            CommandClient.closeQuietly(client);
            throw throwable;
        }
        CommandClient.closeQuietly((CommandClient)client);
    }
}

