/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.TestUtils;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.ResponseStatus;
import org.xdi.oxd.common.params.AuthorizeRptParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.response.ObtainAatOpResponse;
import org.xdi.oxd.common.response.ObtainPatOpResponse;
import org.xdi.oxd.common.response.RegisterPermissionTicketOpResponse;
import org.xdi.oxd.common.response.RegisterResourceOpResponse;

public class AuthorizeRptTest {
    private static final List<String> SCOPES = Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all");
    private static CommandClient g_client = null;
    private static String g_patToken;
    private static String g_aatToken;
    private static String g_rpt;
    private static String g_umaDiscoveryUrl;
    private static String g_amHost;
    private static String g_rsHost;
    private static RegisterResourceOpResponse g_resource;

    @Parameters(value={"host", "port", "discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret", "amHost", "rsHost"})
    @BeforeClass
    public static void setUp(String host, int port, String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret, String amHost, String rsHost) throws IOException {
        g_client = new CommandClient(host, port);
        g_umaDiscoveryUrl = umaDiscoveryUrl;
        g_amHost = amHost;
        g_rsHost = rsHost;
        ObtainPatOpResponse patResponse = TestUtils.obtainPat(g_client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret, userId, userSecret);
        Assert.assertNotNull((Object)patResponse);
        g_patToken = patResponse.getPatToken();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)g_patToken));
        ObtainAatOpResponse aatResponse = TestUtils.obtainAat(g_client, discoveryUrl, umaDiscoveryUrl, redirectUrl, clientId, clientSecret, userId, userSecret);
        Assert.assertNotNull((Object)aatResponse);
        g_aatToken = aatResponse.getAatToken();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)g_aatToken));
        g_resource = TestUtils.registerResource(g_client, umaDiscoveryUrl, g_patToken, SCOPES);
        Assert.assertNotNull((Object)g_resource);
        g_rpt = TestUtils.obtainRpt(g_aatToken, umaDiscoveryUrl, amHost);
        Assert.assertNotNull((Object)StringUtils.isNotBlank((String)g_rpt));
    }

    @AfterClass
    public static void tearDown() {
        CommandClient.closeQuietly((CommandClient)g_client);
    }

    @Test
    public void test() throws IOException {
        RegisterPermissionTicketOpResponse ticketResponse = TestUtils.registerTicket(g_client, g_umaDiscoveryUrl, g_patToken, g_resource.getId(), g_amHost, g_rsHost, SCOPES, "GET", "http://example.com/object/1234");
        Assert.assertTrue((ticketResponse != null && StringUtils.isNotBlank((String)ticketResponse.getTicket()) ? 1 : 0) != 0);
        AuthorizeRptParams params = new AuthorizeRptParams();
        params.setAatToken(g_aatToken);
        params.setRptToken(g_rpt);
        params.setAmHost(g_amHost);
        params.setTicket(ticketResponse.getTicket());
        Command command = new Command(CommandType.AUTHORIZE_RPT);
        command.setParamsObject((IParams)params);
        CommandResponse response = g_client.send(command);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)response.getStatus(), (Object)ResponseStatus.OK);
        System.out.println(response);
    }
}

