/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.params.AuthorizationCodeFlowParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.response.AuthorizationCodeFlowResponse;

public class AuthorizationCodeFlowTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"host", "port", "discoveryUrl", "umaDiscoveryUrl", "redirectUrl", "clientId", "clientSecret", "userId", "userSecret"})
    @Test
    public void test(String host, int port, String discoveryUrl, String umaDiscoveryUrl, String redirectUrl, String clientId, String clientSecret, String userId, String userSecret) throws IOException {
        CommandClient client = null;
        try {
            client = new CommandClient(host, port);
            AuthorizationCodeFlowParams commandParams = new AuthorizationCodeFlowParams();
            commandParams.setClientId(clientId);
            commandParams.setClientSecret(clientSecret);
            commandParams.setDiscoveryUrl(discoveryUrl);
            commandParams.setNonce(UUID.randomUUID().toString());
            commandParams.setRedirectUrl(redirectUrl);
            commandParams.setScope("openid");
            commandParams.setUserId(userId);
            commandParams.setUserSecret(userSecret);
            Command command = new Command(CommandType.AUTHORIZATION_CODE_FLOW);
            command.setParamsObject((IParams)commandParams);
            CommandResponse response = client.send(command);
            Assert.assertNotNull((Object)response);
            CommandResponse r = client.send(command);
            Assert.assertNotNull((Object)r);
            AuthorizationCodeFlowResponse resp = (AuthorizationCodeFlowResponse)r.dataAsResponse(AuthorizationCodeFlowResponse.class);
            Assert.assertNotNull((Object)resp);
            AuthorizationCodeFlowTest.notEmpty(resp.getAccessToken());
            AuthorizationCodeFlowTest.notEmpty(resp.getAuthorizationCode());
            AuthorizationCodeFlowTest.notEmpty(resp.getIdToken());
            AuthorizationCodeFlowTest.notEmpty(resp.getRefreshToken());
            AuthorizationCodeFlowTest.notEmpty(resp.getScope());
        }
        catch (Throwable throwable) {
            CommandClient.closeQuietly(client);
            throw throwable;
        }
        CommandClient.closeQuietly((CommandClient)client);
    }

    private static void notEmpty(String str) {
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)str));
    }
}

