/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InetAddressUtility {
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    private static String macAddress;
    private static boolean macAddressSet;

    public static boolean isIpAddress(String ipAddress) {
        Matcher m1 = VALID_IPV4_PATTERN.matcher(ipAddress);
        if (m1.matches()) {
            return true;
        }
        Matcher m2 = VALID_IPV6_PATTERN.matcher(ipAddress);
        return m2.matches();
    }

    public static String getMACAddressOrNull() {
        if (!macAddressSet) {
            macAddress = InetAddressUtility.getMACAddressOrNullImpl();
            macAddressSet = true;
        }
        return macAddress;
    }

    private static synchronized String getMACAddressOrNullImpl() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                return null;
            }
            byte[] mac = network.getHardwareAddress();
            if (mac == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (SocketException e) {
            return null;
        }
    }

    static {
        VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
        VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
        macAddressSet = false;
    }
}

