/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.xdi.model.SimpleProperty;

@JsonPropertyOrder(value={"configId", "bindDN", "bindPassword", "servers", "maxConnections", "useSSL", "baseDNs", "primaryKey", "localPrimaryKey", "useAnonymousBind", "enabled", "version"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class GluuLdapConfiguration
implements Serializable {
    private static final long serialVersionUID = -7160480457430436511L;
    private String configId;
    private String bindDN;
    private String bindPassword;
    @JsonIgnore
    private List<SimpleProperty> servers;
    @JsonProperty(value="servers")
    private List<String> serversStringsList;
    private int maxConnections;
    private boolean useSSL;
    @JsonIgnore
    private List<SimpleProperty> baseDNs;
    @JsonProperty(value="baseDNs")
    private List<String> baseDNsStringsList;
    private String primaryKey;
    private String localPrimaryKey;
    private boolean useAnonymousBind;
    private boolean enabled;
    private int version;
    @JsonProperty(value="level")
    private int level;

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public GluuLdapConfiguration() {
        this.servers = new ArrayList<SimpleProperty>();
        this.baseDNs = new ArrayList<SimpleProperty>();
        this.updateStringsLists();
    }

    public GluuLdapConfiguration(String configId, String bindDN, String bindPassword, List<String> servers, int maxConnections, boolean useSSL, List<String> baseDNs, String primaryKey, String localPrimaryKey, boolean useAnonymousBind) {
        this.configId = configId;
        this.bindDN = bindDN;
        this.bindPassword = bindPassword;
        this.serversStringsList = servers;
        this.maxConnections = maxConnections;
        this.useSSL = useSSL;
        this.baseDNsStringsList = baseDNs;
        this.primaryKey = primaryKey;
        this.localPrimaryKey = localPrimaryKey;
        this.useAnonymousBind = useAnonymousBind;
        this.updateSimplePropertiesLists();
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public List<SimpleProperty> getServers() {
        return this.servers;
    }

    public void setServers(List<SimpleProperty> servers) {
        this.servers = servers;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public List<SimpleProperty> getBaseDNs() {
        return this.baseDNs;
    }

    public void setBaseDNs(List<SimpleProperty> baseDNs) {
        this.baseDNs = baseDNs;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getLocalPrimaryKey() {
        return this.localPrimaryKey;
    }

    public void setLocalPrimaryKey(String localPrimaryKey) {
        this.localPrimaryKey = localPrimaryKey;
    }

    public boolean isUseAnonymousBind() {
        return this.useAnonymousBind;
    }

    public void setUseAnonymousBind(boolean useAnonymousBind) {
        this.useAnonymousBind = useAnonymousBind;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<String> getServersStringsList() {
        return this.serversStringsList;
    }

    public void setServersStringsList(List<String> serversStringsList) {
        this.serversStringsList = serversStringsList;
        this.updateSimplePropertiesLists();
    }

    public List<String> getBaseDNsStringsList() {
        return this.baseDNsStringsList;
    }

    public void setBaseDNsStringsList(List<String> baseDNsStringsList) {
        this.baseDNsStringsList = baseDNsStringsList;
        this.updateSimplePropertiesLists();
    }

    public void updateStringsLists() {
        this.serversStringsList = this.toStringList(this.servers);
        this.baseDNsStringsList = this.toStringList(this.baseDNs);
    }

    public void updateSimplePropertiesLists() {
        this.servers = this.toSimpleProperties(this.serversStringsList);
        this.baseDNs = this.toSimpleProperties(this.baseDNsStringsList);
    }

    private List<String> toStringList(List<SimpleProperty> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SimpleProperty simpleProperty : values) {
            result.add(simpleProperty.getValue());
        }
        return result;
    }

    private List<SimpleProperty> toSimpleProperties(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<SimpleProperty> result = new ArrayList<SimpleProperty>();
        for (String value : values) {
            result.add(new SimpleProperty(value));
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseDNs == null ? 0 : this.baseDNs.hashCode());
        result = 31 * result + (this.bindDN == null ? 0 : this.bindDN.hashCode());
        result = 31 * result + (this.bindPassword == null ? 0 : this.bindPassword.hashCode());
        result = 31 * result + (this.configId == null ? 0 : this.configId.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.localPrimaryKey == null ? 0 : this.localPrimaryKey.hashCode());
        result = 31 * result + this.maxConnections;
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
        result = 31 * result + (this.useAnonymousBind ? 1231 : 1237);
        result = 31 * result + (this.useSSL ? 1231 : 1237);
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GluuLdapConfiguration)) {
            return false;
        }
        GluuLdapConfiguration other = (GluuLdapConfiguration)obj;
        if (this.baseDNs == null ? other.baseDNs != null : !this.baseDNs.equals(other.baseDNs)) {
            return false;
        }
        if (this.bindDN == null ? other.bindDN != null : !this.bindDN.equals(other.bindDN)) {
            return false;
        }
        if (this.bindPassword == null ? other.bindPassword != null : !this.bindPassword.equals(other.bindPassword)) {
            return false;
        }
        if (this.configId == null ? other.configId != null : !this.configId.equals(other.configId)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.localPrimaryKey == null ? other.localPrimaryKey != null : !this.localPrimaryKey.equals(other.localPrimaryKey)) {
            return false;
        }
        if (this.maxConnections != other.maxConnections) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        if (this.servers == null ? other.servers != null : !this.servers.equals(other.servers)) {
            return false;
        }
        if (this.useAnonymousBind != other.useAnonymousBind) {
            return false;
        }
        if (this.useSSL != other.useSSL) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GluuLdapConfiguration [configId=").append(this.configId).append(", bindDN=").append(this.bindDN).append(", bindPassword=").append(this.bindPassword).append(", servers=").append(this.servers).append(", maxConnections=").append(this.maxConnections).append(", useSSL=").append(this.useSSL).append(", baseDNs=").append(this.baseDNs).append(", primaryKey=").append(this.primaryKey).append(", localPrimaryKey=").append(this.localPrimaryKey).append(", useAnonymousBind=").append(this.useAnonymousBind).append(", enabled=").append(this.enabled).append(", version=").append(this.version).append("]");
        return builder.toString();
    }
}

