/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.xdi.util.ArrayHelper;

public class FileConfiguration {
    private static final Logger log = Logger.getLogger(FileConfiguration.class);
    private String fileName;
    private boolean isResource;
    private boolean loaded;
    protected PropertiesConfiguration propertiesConfiguration;
    protected Properties properties;
    private final ReentrantLock reloadLock = new ReentrantLock();
    private boolean isReload = false;

    public FileConfiguration(String fileName) {
        this(fileName, false);
    }

    public FileConfiguration(String fileName, boolean isResource) {
        this.fileName = fileName;
        this.isResource = isResource;
        this.loaded = false;
        if (isResource) {
            this.loadResourceProperties();
        } else {
            this.loadProperties();
        }
    }

    protected void loadProperties() {
        try {
            this.propertiesConfiguration = new PropertiesConfiguration(this.fileName);
            this.loaded = true;
        }
        catch (ConfigurationException ex) {
            log.debug((Object)String.format("Failed to load '%s' configuration file from config folder", this.fileName));
        }
    }

    protected void loadResourceProperties() {
        log.debug((Object)String.format("Loading '%s' configuration file from resources", this.fileName));
        try {
            this.propertiesConfiguration = new PropertiesConfiguration(this.fileName);
            this.loaded = true;
        }
        catch (ConfigurationException ex) {
            log.debug((Object)String.format("Failed to load '%s' configuration file from resources", this.fileName));
        }
    }

    public void reload() {
        this.isReload = true;
        this.reloadLock.lock();
        try {
            if (!this.isReload) {
                return;
            }
            this.properties = null;
            this.loaded = false;
            if (this.isResource) {
                this.loadResourceProperties();
            } else {
                this.loadProperties();
            }
        }
        finally {
            this.reloadLock.unlock();
            this.isReload = false;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void saveProperties() {
        try {
            this.propertiesConfiguration.save();
        }
        catch (ConfigurationException ex) {
            log.debug((Object)String.format("Failed to save '%s' configuration file to tomcat config folder", this.fileName));
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            Iterator keys = this.propertiesConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.properties.put(key, this.getString(key));
            }
        }
        return this.properties;
    }

    public Properties getPropertiesByPrefix(String propertiesPrefix) {
        Properties properties = new Properties();
        Iterator keys = this.propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(propertiesPrefix)) continue;
            properties.put(key.substring(propertiesPrefix.length()), this.getString(key));
        }
        return properties;
    }

    public String getString(String key) {
        String[] values = this.propertiesConfiguration.getStringArray(key);
        if (values.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(',');
            }
            sb.append(values[values.length - 1]);
            return sb.toString();
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public String[] getStringArray(String key) {
        String[] result = this.propertiesConfiguration.getStringArray(key);
        if (ArrayHelper.isNotEmpty(result) && result.length == 1 && result[0].trim().length() == 0) {
            result = new String[]{};
        }
        return result;
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        try {
            return this.getStringArray(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public List<String> getStringList(String key) {
        String[] values = this.getStringArray(key);
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String value : values) {
            result.add(value);
        }
        return result;
    }

    public int getInt(String key) {
        return this.propertiesConfiguration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.propertiesConfiguration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public int getCountItems(String pattern) {
        int i = 0;
        while (this.propertiesConfiguration.containsKey(String.format(pattern, ++i))) {
        }
        return i - 1;
    }

    public void setString(String key, String value) {
        this.propertiesConfiguration.setProperty(key, (Object)value);
    }

    public boolean isKeyExist(String key) {
        Iterator keyIterator = this.propertiesConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String k = (String)keyIterator.next();
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getKey(String value) {
        Iterator keyIterator = this.propertiesConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String k = (String)keyIterator.next();
            String v = this.propertiesConfiguration.getString(k);
            if (!v.equals(value)) continue;
            return k;
        }
        return null;
    }

    public PropertiesConfiguration getPropertiesConfiguration() {
        return this.propertiesConfiguration;
    }
}

