/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.process;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.log4j.Logger;
import org.xdi.util.StringHelper;

public class ProcessHelper {
    private static Logger log = Logger.getLogger(ProcessHelper.class);
    private static final long PRINT_JOB_TIMEOUT = 100000L;

    private ProcessHelper() {
    }

    public static boolean executeProgram(String programPath, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        return ProcessHelper.executeProgram(programPath, null, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(String programPath, String workingDirectory, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        CommandLine commandLine = new CommandLine(programPath);
        return ProcessHelper.executeProgram(commandLine, workingDirectory, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(CommandLine commandLine, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        return ProcessHelper.executeProgram(commandLine, null, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(CommandLine commandLine, String workingDirectory, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        long printJobTimeout = 100000L;
        PumpStreamHandler streamHandler = null;
        if (outputStream != null) {
            streamHandler = new PumpStreamHandler(outputStream);
        }
        PrintResultHandler printResult = null;
        try {
            log.debug((Object)String.format("Preparing to start process %s", commandLine.toString()));
            printResult = ProcessHelper.executeProgram(commandLine, workingDirectory, printJobTimeout, executeInBackground, successExitValue, (ExecuteStreamHandler)streamHandler);
            log.debug((Object)String.format("Successfully start process %s", commandLine.toString()));
        }
        catch (Exception ex) {
            log.trace((Object)String.format("Problem during starting process %s", commandLine.toString()), (Throwable)ex);
            ex.printStackTrace();
            return false;
        }
        log.debug((Object)String.format("Waiting for the proces %s finish", commandLine.toString()));
        try {
            if (printResult == null) {
                return false;
            }
            printResult.waitFor();
        }
        catch (InterruptedException ex) {
            log.error((Object)String.format("Problem during process execution %s", commandLine.toString()), (Throwable)ex);
        }
        log.debug((Object)String.format("Process %s has finished", commandLine.toString()));
        return true;
    }

    public static PrintResultHandler executeProgram(CommandLine commandLine, long printJobTimeout, boolean printInBackground, int successExitValue, ExecuteStreamHandler streamHandler) throws IOException {
        return ProcessHelper.executeProgram(commandLine, null, printJobTimeout, printInBackground, successExitValue, streamHandler);
    }

    public static PrintResultHandler executeProgram(CommandLine commandLine, String workingDirectory, long printJobTimeout, boolean printInBackground, int successExitValue, ExecuteStreamHandler streamHandler) throws IOException {
        PrintResultHandler resultHandler;
        ExecuteWatchdog watchdog = null;
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(successExitValue);
        if (StringHelper.isNotEmpty(workingDirectory)) {
            executor.setWorkingDirectory(new File(workingDirectory));
        }
        if (streamHandler != null) {
            executor.setStreamHandler(streamHandler);
        }
        if (printJobTimeout > 0L) {
            watchdog = new ExecuteWatchdog(printJobTimeout);
            executor.setWatchdog(watchdog);
        }
        if (printInBackground) {
            log.debug((Object)String.format("Executing non-blocking process %s", commandLine.toString()));
            resultHandler = new PrintResultHandler(watchdog);
            executor.execute(commandLine, (ExecuteResultHandler)resultHandler);
        } else {
            log.debug((Object)String.format("Executing blocking process %s", commandLine.toString()));
            successExitValue = executor.execute(commandLine);
            resultHandler = new PrintResultHandler(successExitValue);
        }
        return resultHandler;
    }

    private static class PrintResultHandler
    extends DefaultExecuteResultHandler {
        private ExecuteWatchdog watchdog;

        public PrintResultHandler(ExecuteWatchdog watchdog) {
            this.watchdog = watchdog;
        }

        public PrintResultHandler(int exitValue) {
            super.onProcessComplete(exitValue);
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            log.debug((Object)"The process successfully executed");
        }

        public void onProcessFailed(ExecuteException ex) {
            super.onProcessFailed(ex);
            if (this.watchdog != null && this.watchdog.killedProcess()) {
                log.debug((Object)"The process timed out");
            } else {
                log.debug((Object)"The process failed to do", (Throwable)ex);
            }
        }
    }
}

