/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.saml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.gluu.saml.exception.CloneFailedException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.xdi.util.security.CertificateHelper;

public class SamlConfiguration {
    private String idpSsoTargetUrl;
    private String assertionConsumerServiceUrl;
    private String issuer;
    private String nameIdentifierFormat;
    private X509Certificate certificate;
    private boolean useRequestedAuthnContext;
    private PrivateKey privateKey;
    private String sigAlg = "SHA256withRSA";
    private String sigAlgUrl = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";

    public String getIdpSsoTargetUrl() {
        return this.idpSsoTargetUrl;
    }

    public void setIdpSsoTargetUrl(String idpSsoTargetUrl) {
        this.idpSsoTargetUrl = idpSsoTargetUrl;
    }

    public String getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getNameIdentifierFormat() {
        return this.nameIdentifierFormat;
    }

    public void setNameIdentifierFormat(String nameIdentifierFormat) {
        this.nameIdentifierFormat = nameIdentifierFormat;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public boolean isUseRequestedAuthnContext() {
        return this.useRequestedAuthnContext;
    }

    public void setUseRequestedAuthnContext(boolean useRequestedAuthnContext) {
        this.useRequestedAuthnContext = useRequestedAuthnContext;
    }

    public void loadCertificateFromString(String certificateString) throws CertificateException {
        this.certificate = CertificateHelper.loadCertificate((String)certificateString);
    }

    public Object clone() throws CloneFailedException {
        try {
            return BeanUtils.cloneBean((Object)this);
        }
        catch (Exception ex) {
            throw new CloneFailedException(ex);
        }
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    public void setSigAlg(String sigAlg) {
        this.sigAlg = sigAlg;
    }

    public String getSigAlgUrl() {
        return this.sigAlgUrl;
    }

    public void setSigAlgUrl(String sigAlgUrl) {
        this.sigAlgUrl = sigAlgUrl;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void loadPrivateKey(String prvKeyPath) throws Exception {
        OpenSAMLUtil.initSamlEngine();
        File privKeyFile = new File(prvKeyPath);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(privKeyFile));
        }
        catch (FileNotFoundException e) {
            throw new Exception("Could not locate keyfile at '" + prvKeyPath + "'", e);
        }
        byte[] privKeyBytes = new byte[(int)privKeyFile.length()];
        bis.read(privKeyBytes);
        bis.close();
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(privKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        this.privateKey = keyFactory.generatePrivate(ks);
    }

    protected Credential getCredential() {
        BasicCredential credential = new BasicCredential();
        credential.setPublicKey(this.certificate.getPublicKey());
        credential.setPrivateKey(this.privateKey);
        credential.setUsageType(UsageType.SIGNING);
        return credential;
    }
}

