/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.saml.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntityIDHandler
extends DefaultHandler {
    private List<String> entityIDs = null;
    private String currentEntityID;
    private List<String> spEntityIDs = null;
    private List<String> idpEntityIDs = null;
    private Map<String, String> organizations = null;
    private boolean waitingForName;

    public List<String> getEntityIDs() {
        return this.entityIDs;
    }

    public List<String> getSpEntityIDs() {
        return this.spEntityIDs;
    }

    public List<String> getIdpEntityIDs() {
        return this.idpEntityIDs;
    }

    public Map<String, String> getOrganizations() {
        return this.organizations;
    }

    @Override
    public void startDocument() {
        this.entityIDs = new ArrayList<String>();
        this.spEntityIDs = new ArrayList<String>();
        this.idpEntityIDs = new ArrayList<String>();
        this.organizations = new HashMap<String, String>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.waitingForName = false;
        if (qName.contains("EntityDescriptor")) {
            this.currentEntityID = attributes.getValue("entityID");
            this.entityIDs.add(this.currentEntityID);
            return;
        }
        if (qName.contains("SPSSODescriptor")) {
            this.spEntityIDs.add(this.currentEntityID);
            return;
        }
        if (qName.contains("IDPSSODescriptor")) {
            this.idpEntityIDs.add(this.currentEntityID);
            return;
        }
        if (qName.contains("OrganizationDisplayName")) {
            this.waitingForName = true;
            return;
        }
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) {
        if (this.waitingForName) {
            this.organizations.put(this.currentEntityID, new String(arg0, arg1, arg2));
            this.waitingForName = false;
        }
    }
}

