/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.saml.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.saml.metadata.EntityIDHandler;
import org.xdi.util.io.HTTPFileDownloader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAMLMetadataParser {
    private static final Log log = LogFactory.getLog(SAMLMetadataParser.class);

    public static List<String> getEntityIdFromMetadataFile(File metadataFile) {
        if (!metadataFile.isFile()) {
            return null;
        }
        EntityIDHandler handler = SAMLMetadataParser.parseMetadata(metadataFile);
        List<String> entityIds = handler.getEntityIDs();
        if (entityIds == null || entityIds.isEmpty()) {
            log.error((Object)("Failed to find entityId in metadata file: " + metadataFile.getAbsolutePath()));
        }
        return entityIds;
    }

    public static List<String> getSpEntityIdFromMetadataFile(File metadataFile) {
        EntityIDHandler handler = SAMLMetadataParser.parseMetadata(metadataFile);
        List<String> entityIds = handler.getSpEntityIDs();
        if (entityIds == null || entityIds.isEmpty()) {
            log.error((Object)("Failed to find entityId in metadata file: " + metadataFile.getAbsolutePath()));
        }
        return entityIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityIDHandler parseMetadata(File metadataFile) {
        if (!metadataFile.exists()) {
            log.error((Object)("Failed to get entityId from metadata file: " + metadataFile.getAbsolutePath()));
            return null;
        }
        FileInputStream is = null;
        try {
            is = FileUtils.openInputStream((File)metadataFile);
            EntityIDHandler entityIDHandler = SAMLMetadataParser.parseMetadata(is);
            return entityIDHandler;
        }
        catch (IOException ex) {
            log.error((Object)("Failed to read SAML metadata file: " + metadataFile.getAbsolutePath()), (Throwable)ex);
            EntityIDHandler entityIDHandler = null;
            return entityIDHandler;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityIDHandler parseMetadata(InputStream is) {
        Reader isr = null;
        EntityIDHandler handler = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            handler = new EntityIDHandler();
            saxParser.parse(is, (DefaultHandler)handler);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to read SAML metadata", (Throwable)ex);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to confugure SAX parser", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"Failed to parse SAML metadata", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)is);
        }
        return handler;
    }

    public static EntityIDHandler parseMetadata(URL metadataURL) {
        String metadataFileContent = HTTPFileDownloader.getResource((String)metadataURL.toExternalForm(), (String)"application/xml, text/xml", null, null);
        return SAMLMetadataParser.parseMetadata(metadataFileContent);
    }

    public static EntityIDHandler parseMetadata(String metadata) {
        if (metadata == null) {
            return null;
        }
        StringBufferInputStream is = new StringBufferInputStream(metadata);
        return SAMLMetadataParser.parseMetadata(is);
    }
}

