/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.ldap.operation.impl;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldif.LDIFChangeRecord;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gluu.persist.exception.MappingException;
import org.gluu.persist.exception.operation.ConnectionException;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.ldap.exception.InvalidSimplePageControlException;
import org.gluu.persist.ldap.impl.LdapBatchOperationWraper;
import org.gluu.persist.ldap.operation.LdapOperationService;
import org.gluu.persist.ldap.operation.impl.LdapConnectionProvider;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.operation.auth.PasswordEncryptionHelper;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.ArrayHelper;
import org.xdi.util.Pair;
import org.xdi.util.StringHelper;

public class LdapOperationsServiceImpl
implements LdapOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapOperationsServiceImpl.class);
    public static final String DN = "dn";
    public static final String UID = "uid";
    public static final String SUCCESS = "success";
    public static final String USER_PASSWORD = "userPassword";
    public static final String OBJECT_CLASS = "objectClass";
    private LdapConnectionProvider connectionProvider;
    private LdapConnectionProvider bindConnectionProvider;
    private static Map<String, Class<?>> ATTRIBUTE_DATA_TYPES = new HashMap();
    private static final Map<String, Class<?>> OID_SYNTAX_CLASS_MAPPING = new HashMap();

    private LdapOperationsServiceImpl() {
    }

    public LdapOperationsServiceImpl(LdapConnectionProvider connectionProvider) {
        this(connectionProvider, null);
        this.populateAttributeDataTypesMapping(this.getSubschemaSubentry());
    }

    public LdapOperationsServiceImpl(LdapConnectionProvider connectionProvider, LdapConnectionProvider bindConnectionProvider) {
        this.connectionProvider = connectionProvider;
        this.bindConnectionProvider = bindConnectionProvider;
        this.populateAttributeDataTypesMapping(this.getSubschemaSubentry());
    }

    @Override
    public LdapConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public void setConnectionProvider(LdapConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public LdapConnectionProvider getBindConnectionProvider() {
        return this.bindConnectionProvider;
    }

    @Override
    public void setBindConnectionProvider(LdapConnectionProvider bindConnectionProvider) {
        this.bindConnectionProvider = bindConnectionProvider;
    }

    @Override
    public LDAPConnectionPool getConnectionPool() {
        return this.connectionProvider.getConnectionPool();
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionProvider.getConnection();
    }

    @Override
    public void releaseConnection(LDAPConnection connection) {
        this.connectionProvider.releaseConnection(connection);
    }

    @Override
    public boolean authenticate(String bindDn, String password) throws ConnectionException {
        try {
            return this.authenticateImpl(bindDn, password);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate dn", (Throwable)ex);
        }
    }

    private boolean authenticateImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        ArrayList<PasswordEncryptionMethod> additionalPasswordMethods = this.connectionProvider.getAdditionalPasswordMethods();
        if (!additionalPasswordMethods.isEmpty()) {
            SearchResultEntry searchResult = this.lookup(bindDn, USER_PASSWORD);
            if (searchResult == null) {
                throw new ConnectionException("Failed to find use by dn");
            }
            String storedUserPassword = searchResult.getAttribute(USER_PASSWORD).getValue();
            PasswordEncryptionMethod storedPasswordMethod = PasswordEncryptionHelper.findAlgorithm((String)storedUserPassword);
            if (additionalPasswordMethods.contains(storedPasswordMethod)) {
                LOG.debug("Authenticating '{}' using internal authentication mechanism '{}'", (Object)bindDn, (Object)storedPasswordMethod);
                return PasswordEncryptionHelper.compareCredentials((String)password, (String)storedUserPassword);
            }
        }
        if (this.bindConnectionProvider == null) {
            return this.authenticateConnectionPoolImpl(bindDn, password);
        }
        return this.authenticateBindConnectionPoolImpl(bindDn, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        boolean loggedIn = false;
        if (bindDn == null) {
            return loggedIn;
        }
        boolean closeConnection = false;
        LDAPConnection connection = this.connectionProvider.getConnection();
        try {
            closeConnection = true;
            BindResult r = connection.bind(bindDn, password);
            if (r.getResultCode() == ResultCode.SUCCESS) {
                loggedIn = true;
            }
        }
        finally {
            this.connectionProvider.releaseConnection(connection);
            if (closeConnection) {
                this.connectionProvider.closeDefunctConnection(connection);
            }
        }
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateBindConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (bindDn == null) {
            return false;
        }
        LDAPConnection connection = this.bindConnectionProvider.getConnection();
        try {
            BindResult r = connection.bind(bindDn, password);
            boolean bl = r.getResultCode() == ResultCode.SUCCESS;
            return bl;
        }
        finally {
            this.bindConnectionProvider.releaseConnection(connection);
        }
    }

    @Override
    public SearchResult search(String dn, Filter filter, int searchLimit, int count) throws SearchException {
        return this.search(dn, filter, searchLimit, count, null, (String[])null);
    }

    @Override
    public SearchResult search(String dn, Filter filter, int searchLimit, int count, Control[] controls, String ... attributes) throws SearchException {
        return this.search(dn, filter, SearchScope.SUB, searchLimit, count, controls, attributes);
    }

    @Override
    public SearchResult search(String dn, Filter filter, SearchScope scope, int searchLimit, int count, Control[] controls, String ... attributes) throws SearchException {
        return this.search(dn, filter, scope, null, 0, searchLimit, count, controls, attributes);
    }

    @Override
    public <T> SearchResult search(String dn, Filter filter, SearchScope scope, LdapBatchOperationWraper<T> batchOperationWraper, int start, int searchLimit, int count, Control[] controls, String ... attributes) throws SearchException {
        boolean useSizeLimit;
        BatchOperation<T> ldapBatchOperation = null;
        if (batchOperationWraper != null) {
            ldapBatchOperation = batchOperationWraper.getBatchOperation();
        }
        if (LOG.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            LOG.trace("Search in whole LDAP tree", (Throwable)new Exception());
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope, filter, new String[0]) : new SearchRequest(dn, scope, filter, attributes);
        boolean bl = useSizeLimit = count > 0;
        if (useSizeLimit) {
            searchLimit = count;
        }
        SearchResult searchResult = null;
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
        ArrayList searchResultEntries = new ArrayList();
        ArrayList searchResultReferences = new ArrayList();
        if (searchLimit > 0 || start > 0) {
            boolean collectSearchResult;
            if (searchLimit == 0) {
                searchLimit = 100;
            }
            LDAPConnection ldapConnection = null;
            try {
                ldapConnection = this.getConnectionPool().getConnection();
                ASN1OctetString cookie = null;
                if (start > 0) {
                    try {
                        cookie = this.scrollSimplePagedResultsControl(ldapConnection, dn, filter, scope, controls, start);
                    }
                    catch (InvalidSimplePageControlException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified start", (Throwable)((Object)ex));
                    }
                    catch (LDAPException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified start", (Throwable)ex);
                    }
                }
                do {
                    collectSearchResult = true;
                    searchRequest.setControls(new Control[]{new SimplePagedResultsControl(searchLimit, cookie)});
                    this.setControls(searchRequest, controls);
                    searchResult = ldapConnection.search(searchRequest);
                    if (ldapBatchOperation != null) {
                        collectSearchResult = ldapBatchOperation.collectSearchResult(searchResult.getEntryCount());
                    }
                    if (collectSearchResult) {
                        searchResultList.add(searchResult);
                        searchResultEntries.addAll(searchResult.getSearchEntries());
                        searchResultReferences.addAll(searchResult.getSearchReferences());
                    }
                    if (ldapBatchOperation != null) {
                        List<T> entries = batchOperationWraper.createEntities(searchResult);
                        ldapBatchOperation.performAction(entries);
                    }
                    cookie = null;
                    try {
                        SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                        if (c != null) {
                            cookie = c.getCookie();
                        }
                    }
                    catch (LDAPException ex) {
                        LOG.error("Error while accessing cookies" + ex.getMessage());
                    }
                    if (!useSizeLimit) continue;
                    break;
                } while (cookie != null && cookie.getValueLength() > 0);
            }
            catch (LDAPException ex) {
                throw new SearchException("Failed to scroll to specified start", (Throwable)ex, ex.getResultCode().intValue());
            }
            finally {
                if (ldapConnection != null) {
                    this.getConnectionPool().releaseConnection(ldapConnection);
                }
            }
            if (!collectSearchResult) {
                return new SearchResult(searchResult.getMessageID(), searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), searchResult.getReferralURLs(), searchResultEntries, searchResultReferences, searchResultEntries.size(), searchResultReferences.size(), searchResult.getResponseControls());
            }
            if (!searchResultList.isEmpty()) {
                SearchResult searchResultTemp = (SearchResult)searchResultList.get(0);
                return new SearchResult(searchResultTemp.getMessageID(), searchResultTemp.getResultCode(), searchResultTemp.getDiagnosticMessage(), searchResultTemp.getMatchedDN(), searchResultTemp.getReferralURLs(), searchResultEntries, searchResultReferences, searchResultEntries.size(), searchResultReferences.size(), searchResultTemp.getResponseControls());
            }
        } else {
            this.setControls(searchRequest, controls);
            try {
                searchResult = this.getConnectionPool().search(searchRequest);
            }
            catch (LDAPSearchException ex) {
                throw new SearchException(ex.getMessage(), (Throwable)ex, ex.getResultCode().intValue());
            }
        }
        return searchResult;
    }

    private ASN1OctetString scrollSimplePagedResultsControl(LDAPConnection ldapConnection, String dn, Filter filter, SearchScope scope, Control[] controls, int start) throws LDAPException, InvalidSimplePageControlException {
        SearchRequest searchRequest = new SearchRequest(dn, scope, filter, new String[]{DN});
        int currentStartIndex = start;
        ASN1OctetString cookie = null;
        do {
            int pageSize = Math.min(currentStartIndex, 100);
            searchRequest.setControls(new Control[]{new SimplePagedResultsControl(pageSize, cookie, true)});
            this.setControls(searchRequest, controls);
            SearchResult searchResult = ldapConnection.search(searchRequest);
            currentStartIndex -= searchResult.getEntryCount();
            try {
                SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                if (c == null) continue;
                cookie = c.getCookie();
            }
            catch (LDAPException ex) {
                LOG.error("Error while accessing cookie", (Throwable)ex);
                throw new InvalidSimplePageControlException(ex.getResultCode(), "Error while accessing cookie");
            }
        } while (cookie != null && cookie.getValueLength() > 0 && currentStartIndex > 0);
        return cookie;
    }

    @Override
    public SearchResult searchSearchResult(String dn, Filter filter, SearchScope scope, int start, int count, int searchLimit, String sortBy, SortOrder sortOrder, PagedResult vlvResponse, String ... attributes) throws Exception {
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope, filter, new String[0]) : new SearchRequest(dn, scope, filter, attributes);
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
        ArrayList searchResultEntries = new ArrayList();
        ArrayList searchResultReferences = new ArrayList();
        searchRequest.setControls(new Control[]{new SimplePagedResultsControl(searchLimit)});
        SearchResult searchResult = this.getConnectionPool().search(searchRequest);
        List<SearchResultEntry> resultSearchResultEntries = searchResult.getSearchEntries();
        int totalResults = resultSearchResultEntries.size();
        if (StringUtils.isNotEmpty((String)sortBy)) {
            boolean ascending = sortOrder == null || sortOrder.equals((Object)SortOrder.ASCENDING);
            resultSearchResultEntries = this.sortListByAttributes(resultSearchResultEntries, SearchResultEntry.class, false, ascending, sortBy);
        }
        List<Object> searchResultEntryList = new ArrayList();
        if (start <= totalResults) {
            int diff = totalResults - start;
            if (diff <= count) {
                count = diff + 1 >= count ? count : diff + 1;
            }
            int startZeroIndex = start - 1;
            searchResultEntryList = resultSearchResultEntries.subList(startZeroIndex, startZeroIndex + count);
        }
        searchResultList.add(searchResult);
        searchResultEntries.addAll(searchResultEntryList);
        searchResultReferences.addAll(searchResult.getSearchReferences());
        SearchResult searchResultTemp = (SearchResult)searchResultList.get(0);
        searchResult = new SearchResult(searchResultTemp.getMessageID(), searchResultTemp.getResultCode(), searchResultTemp.getDiagnosticMessage(), searchResultTemp.getMatchedDN(), searchResultTemp.getReferralURLs(), searchResultEntries, searchResultReferences, searchResultEntries.size(), searchResultReferences.size(), searchResultTemp.getResponseControls());
        vlvResponse.setEntriesCount(count);
        vlvResponse.setTotalEntriesCount(totalResults);
        vlvResponse.setStart(start);
        return searchResult;
    }

    @Override
    @Deprecated
    public SearchResult searchVirtualListView(String dn, Filter filter, SearchScope scope, int start, int count, String sortBy, SortOrder sortOrder, PagedResult vlvResponse, String ... attributes) throws Exception {
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope, filter, new String[0]) : new SearchRequest(dn, scope, filter, attributes);
        int targetOffset = start;
        int beforeCount = 0;
        int afterCount = count > 0 ? count - 1 : 0;
        int contentCount = 0;
        boolean reverseOrder = false;
        if (sortOrder != null) {
            reverseOrder = sortOrder.equals((Object)SortOrder.DESCENDING);
        }
        searchRequest.setControls(new Control[]{new ServerSideSortRequestControl(new SortKey[]{new SortKey(sortBy, reverseOrder)}), new VirtualListViewRequestControl(targetOffset, beforeCount, afterCount, contentCount, null)});
        SearchResult searchResult = this.getConnectionPool().search(searchRequest);
        VirtualListViewResponseControl vlvResponseControl = VirtualListViewResponseControl.get((SearchResult)searchResult);
        vlvResponse.setEntriesCount(searchResult.getEntryCount());
        vlvResponse.setTotalEntriesCount(vlvResponseControl.getContentCount());
        vlvResponse.setStart(vlvResponseControl.getTargetPosition());
        return searchResult;
    }

    private void setControls(SearchRequest searchRequest, Control ... controls) {
        if (!ArrayHelper.isEmpty((Object[])controls)) {
            Control[] newControls = ArrayHelper.isEmpty((Object[])searchRequest.getControls()) ? controls : (Control[])ArrayHelper.arrayMerge((Object[][])new Control[][]{searchRequest.getControls(), controls});
            searchRequest.setControls(newControls);
        }
    }

    @Override
    public SearchResultEntry lookup(String dn) throws ConnectionException {
        return this.lookup(dn, null);
    }

    @Override
    public SearchResultEntry lookup(String dn, String ... attributes) throws ConnectionException {
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        try {
            if (attributes == null) {
                return this.getConnectionPool().getEntry(dn);
            }
            return this.getConnectionPool().getEntry(dn, attributes);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to lookup entry", (Throwable)ex);
        }
    }

    @Override
    public boolean addEntry(String dn, Collection<Attribute> atts) throws DuplicateEntryException, ConnectionException {
        try {
            LDAPResult result = this.getConnectionPool().add(dn, atts);
            if (result.getResultCode().getName().equalsIgnoreCase(SUCCESS)) {
                return true;
            }
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 68) {
                throw new DuplicateEntryException();
            }
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", (Throwable)ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", (Throwable)ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", (Throwable)ex);
            }
            throw new ConnectionException("Error adding entry to directory. LDAP error number " + errorCode, (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean updateEntry(String dn, Collection<Attribute> attrs) throws DuplicateEntryException, ConnectionException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute attribute : attrs) {
            String attributeName = attribute.getName();
            String attributeValue = attribute.getValue();
            if (attributeName.equalsIgnoreCase(OBJECT_CLASS) || attributeName.equalsIgnoreCase(DN) || attributeName.equalsIgnoreCase(USER_PASSWORD) || attributeValue == null) continue;
            mods.add(new Modification(ModificationType.REPLACE, attributeName, attributeValue));
        }
        return this.updateEntry(dn, (List<Modification>)mods);
    }

    @Override
    public boolean updateEntry(String dn, List<Modification> modifications) throws DuplicateEntryException, ConnectionException {
        ModifyRequest modifyRequest = new ModifyRequest(dn, modifications);
        return this.modifyEntry(modifyRequest);
    }

    protected boolean modifyEntry(ModifyRequest modifyRequest) throws DuplicateEntryException, ConnectionException {
        LDAPResult modifyResult = null;
        try {
            modifyResult = this.getConnectionPool().modify(modifyRequest);
            return ResultCode.SUCCESS.equals((Object)modifyResult.getResultCode());
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", (Throwable)ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", (Throwable)ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", (Throwable)ex);
            }
            throw new ConnectionException("Error updating entry in directory. LDAP error number " + errorCode, (Throwable)ex);
        }
    }

    @Override
    public void delete(String dn) throws ConnectionException {
        try {
            this.getConnectionPool().delete(dn);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public void deleteWithSubtree(String dn) throws ConnectionException {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            deleteRequest.addControl((Control)new SubtreeDeleteRequestControl());
            this.getConnectionPool().delete(deleteRequest);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processChange(LDIFChangeRecord ldifRecord) throws LDAPException {
        LDAPConnection connection = this.getConnection();
        try {
            LDAPResult ldapResult = ldifRecord.processChange((LDAPInterface)connection);
            boolean bl = ResultCode.SUCCESS.equals((Object)ldapResult.getResultCode());
            return bl;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public int getSupportedLDAPVersion() {
        return this.connectionProvider.getSupportedLDAPVersion();
    }

    @Override
    public String getSubschemaSubentry() {
        return this.connectionProvider.getSubschemaSubentry();
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.closeConnectionPool();
            }
            catch (Exception ex) {
                LOG.error("Failed to close connection pool correctly");
                result = false;
            }
        }
        if (this.bindConnectionProvider != null) {
            try {
                this.bindConnectionProvider.closeConnectionPool();
            }
            catch (Exception ex) {
                LOG.error("Failed to close bind connection pool correctly");
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean isBinaryAttribute(String attributeName) {
        return this.connectionProvider.isBinaryAttribute(attributeName);
    }

    @Override
    public boolean isCertificateAttribute(String attributeName) {
        return this.connectionProvider.isCertificateAttribute(attributeName);
    }

    @Override
    public String getCertificateAttributeName(String attributeName) {
        return this.connectionProvider.getCertificateAttributeName(attributeName);
    }

    @Override
    public <T> List<T> sortListByAttributes(List<T> searchResultEntries, Class<T> cls, boolean caseSensitive, boolean ascending, String ... sortByAttributes) {
        if (searchResultEntries == null) {
            throw new MappingException("Entries list to sort is null");
        }
        if (searchResultEntries.size() == 0) {
            return searchResultEntries;
        }
        SearchResultEntryComparator comparator = new SearchResultEntryComparator(sortByAttributes, caseSensitive, ascending);
        Object[] dummyArr = (Object[])Array.newInstance(cls, 0);
        Object[] array = searchResultEntries.toArray(dummyArr);
        Arrays.sort(array, comparator);
        return Arrays.asList(array);
    }

    private void populateAttributeDataTypesMapping(String schemaEntryDn) {
        try {
            if (ATTRIBUTE_DATA_TYPES.size() == 0) {
                SearchResultEntry entry = this.lookup(schemaEntryDn, "attributeTypes");
                Attribute attrAttributeTypes = entry.getAttribute("attributeTypes");
                HashMap<String, Pair> tmpMap = new HashMap<String, Pair>();
                for (String strAttributeType : attrAttributeTypes.getValues()) {
                    AttributeTypeDefinition attrTypeDef = new AttributeTypeDefinition(strAttributeType);
                    String[] names = attrTypeDef.getNames();
                    if (names == null) continue;
                    for (String name : names) {
                        tmpMap.put(name, new Pair((Object)attrTypeDef.getBaseSyntaxOID(), (Object)attrTypeDef.getSuperiorType()));
                    }
                }
                for (String name : tmpMap.keySet()) {
                    Pair pair;
                    Pair currPair = (Pair)tmpMap.get(name);
                    String sup = (String)currPair.getSecond();
                    if (currPair.getFirst() != null || sup == null || (pair = (Pair)tmpMap.get(sup)) == null) continue;
                    currPair.setFirst(pair.getFirst());
                }
                for (String name : tmpMap.keySet()) {
                    Class<?> cls;
                    String syntaxOID = (String)((Pair)tmpMap.get(name)).getFirst();
                    if (syntaxOID == null || (cls = OID_SYNTAX_CLASS_MAPPING.get(syntaxOID)) == null) continue;
                    ATTRIBUTE_DATA_TYPES.put(name, cls);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    static {
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.7", Boolean.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.11", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.15", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.12", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.22", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.24", Date.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.26", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.27", Integer.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.36", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.41", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.50", String.class);
    }

    private static final class SearchResultEntryComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 574848841116711467L;
        private String[] sortByAttributes;
        private boolean caseSensitive;
        private boolean ascending;

        private SearchResultEntryComparator(String[] sortByAttributes, boolean caseSensitive, boolean ascending) {
            this.sortByAttributes = sortByAttributes;
            this.caseSensitive = caseSensitive;
            this.ascending = ascending;
        }

        @Override
        public int compare(T entry1, T entry2) {
            int result = 0;
            if (entry1 == null) {
                result = entry2 == null ? 0 : -1;
            } else if (entry2 == null) {
                result = 1;
            } else {
                String currSortByAttribute;
                String[] stringArray = this.sortByAttributes;
                int n = stringArray.length;
                for (int i = 0; i < n && (result = this.compare(entry1, entry2, currSortByAttribute = stringArray[i])) == 0; ++i) {
                }
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public int compare(T entry1, T entry2, String attributeName) {
            int result = 0;
            try {
                if (entry1 instanceof SearchResultEntry) {
                    SearchResultEntry resultEntry1 = (SearchResultEntry)entry1;
                    SearchResultEntry resultEntry2 = (SearchResultEntry)entry2;
                    String value1 = resultEntry1.getAttributeValue(attributeName);
                    String value2 = resultEntry2.getAttributeValue(attributeName);
                    if (value1 == null) {
                        result = value2 == null ? 0 : -1;
                    } else if (value2 == null) {
                        result = 1;
                    } else {
                        Class cls = (Class)ATTRIBUTE_DATA_TYPES.get(attributeName);
                        if (cls != null) {
                            if (cls.equals(String.class)) {
                                result = this.caseSensitive ? value1.compareTo(value2) : value1.toLowerCase().compareTo(value2.toLowerCase());
                            } else if (cls.equals(Integer.class)) {
                                result = resultEntry1.getAttributeValueAsInteger(attributeName).compareTo(resultEntry2.getAttributeValueAsInteger(attributeName));
                            } else if (cls.equals(Boolean.class)) {
                                result = resultEntry1.getAttributeValueAsBoolean(attributeName).compareTo(resultEntry2.getAttributeValueAsBoolean(attributeName));
                            } else if (cls.equals(Date.class)) {
                                result = resultEntry1.getAttributeValueAsDate(attributeName).compareTo(resultEntry2.getAttributeValueAsDate(attributeName));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error occurred when comparing entries with SearchResultEntryComparator");
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return result;
        }
    }
}

