/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.ldap.impl;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.gluu.persist.event.DeleteNotifier;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.exception.MappingException;
import org.gluu.persist.exception.operation.ConnectionException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.exception.operation.SearchScopeException;
import org.gluu.persist.impl.BaseEntryManager;
import org.gluu.persist.ldap.impl.LdapBatchOperationWraper;
import org.gluu.persist.ldap.impl.LdapFilterConverter;
import org.gluu.persist.ldap.impl.LdapSearchScopeConverter;
import org.gluu.persist.ldap.impl.LdifDataUtility;
import org.gluu.persist.ldap.operation.impl.LdapOperationsServiceImpl;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.AttributeDataModification;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.DefaultBatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.ArrayHelper;
import org.xdi.util.StringHelper;

public class LdapEntryManager
extends BaseEntryManager
implements Serializable {
    private static final long serialVersionUID = -2544614410981223105L;
    private static final Logger LOG = LoggerFactory.getLogger(LdapEntryManager.class);
    private static final LdapFilterConverter LDAP_FILTER_CONVERTER = new LdapFilterConverter();
    private static final LdapSearchScopeConverter LDAP_SEARCH_SCOPE_CONVERTER = new LdapSearchScopeConverter();
    private LdapOperationsServiceImpl operationService;
    private List<DeleteNotifier> subscribers;

    public LdapEntryManager() {
    }

    public LdapEntryManager(LdapOperationsServiceImpl operationService) {
        this.operationService = operationService;
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        if (this.operationService == null) {
            return true;
        }
        return this.operationService.destroy();
    }

    public LdapOperationsServiceImpl getOperationService() {
        return this.operationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    public <T> T merge(T entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() > 2) {
                return (T)this.merge(entry, true, AttributeDataModification.AttributeModificationType.ADD);
            }
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        return (T)this.merge(entry, false, null);
    }

    protected <T> void updateMergeChanges(T entry, boolean isSchemaUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromLdapMap, List<AttributeDataModification> attributeDataModifications) {
        if (this.getSupportedLDAPVersion() > 2 && !isSchemaUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            Object[] objectClassesFromLdap = attributesFromLdapMap.get("objectClass".toLowerCase()).getValues();
            if (!Arrays.equals(objectClassesFromLdap, objectClasses)) {
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData("objectClass", (String[])objectClasses), new AttributeData("objectClass", (String[])objectClassesFromLdap)));
            }
        }
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() <= 2) {
                throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
            }
            this.merge(entry, true, AttributeDataModification.AttributeModificationType.REMOVE);
            return;
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        LOG.debug(String.format("LDAP entry to remove: %s", dnValue.toString()));
        this.remove(dnValue.toString());
    }

    protected void persist(String dn, List<AttributeData> attributes) {
        ArrayList<Attribute> ldapAttributes = new ArrayList<Attribute>(attributes.size());
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            Object[] attributeValues = attribute.getValues();
            if (!ArrayHelper.isNotEmpty((Object[])attributeValues) || !StringHelper.isNotEmpty((String)attributeValues[0])) continue;
            if (this.operationService.isCertificateAttribute(attributeName)) {
                byte[][] binaryValues = this.toBinaryValues((String[])attributeValues);
                ldapAttributes.add(new Attribute(attributeName + ";binary", binaryValues));
                continue;
            }
            ldapAttributes.add(new Attribute(attributeName, (String[])attributeValues));
        }
        try {
            boolean result = this.operationService.addEntry(dn, ldapAttributes);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), (Throwable)ex);
        }
    }

    public void merge(String dn, List<AttributeDataModification> attributeDataModifications) {
        try {
            boolean result;
            ArrayList<Modification> modifications = new ArrayList<Modification>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                String attributeName = null;
                Object[] attributeValues = null;
                if (attribute != null) {
                    attributeName = attribute.getName();
                    attributeValues = attribute.getValues();
                }
                String oldAttributeName = null;
                Object[] oldAttributeValues = null;
                if (oldAttribute != null) {
                    oldAttributeName = oldAttribute.getName();
                    oldAttributeValues = oldAttribute.getValues();
                }
                Modification modification = null;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(ModificationType.ADD, attributeName, (String[])attributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REMOVE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(ModificationType.DELETE, oldAttributeName, (String[])oldAttributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REPLACE.equals((Object)attributeDataModification.getModificationType())) {
                    if (attributeValues.length == 1) {
                        modification = this.createModification(ModificationType.REPLACE, attributeName, (String[])attributeValues);
                    } else {
                        Object[] oldValues = (String[])ArrayHelper.arrayClone((Object[])oldAttributeValues);
                        Object[] newValues = (String[])ArrayHelper.arrayClone((Object[])attributeValues);
                        Arrays.sort(oldValues);
                        Arrays.sort(newValues);
                        boolean[] retainOldValues = new boolean[oldValues.length];
                        Arrays.fill(retainOldValues, false);
                        ArrayList<Object> addValues = new ArrayList<Object>();
                        ArrayList<Object> removeValues = new ArrayList<Object>();
                        for (Object value : newValues) {
                            int idx = Arrays.binarySearch(oldValues, value, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                                }
                            });
                            if (idx >= 0) {
                                retainOldValues[idx] = true;
                                continue;
                            }
                            addValues.add(value);
                        }
                        for (int i = 0; i < oldValues.length; ++i) {
                            if (retainOldValues[i]) continue;
                            removeValues.add(oldValues[i]);
                        }
                        if (removeValues.size() > 0) {
                            Modification removeModification = this.createModification(ModificationType.DELETE, attributeName, removeValues.toArray(new String[removeValues.size()]));
                            modifications.add(removeModification);
                        }
                        if (addValues.size() > 0) {
                            Modification addModification = this.createModification(ModificationType.ADD, attributeName, addValues.toArray(new String[addValues.size()]));
                            modifications.add(addModification);
                        }
                    }
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.operationService.updateEntry(dn, (List<Modification>)modifications))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), (Throwable)ex);
        }
    }

    protected void remove(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.operationService.delete(dn);
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    public void removeRecursively(String dn) {
        try {
            if (this.operationService.getConnectionProvider().isSupportsSubtreeDeleteRequestControl()) {
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onBeforeRemove(dn);
                }
                this.operationService.deleteWithSubtree(dn);
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onAfterRemove(dn);
                }
            } else {
                this.removeSubtreeThroughIteration(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    private void removeSubtreeThroughIteration(String dn) {
        SearchResult searchResult = null;
        try {
            searchResult = this.operationService.search(dn, this.toLdapFilter(Filter.createPresenceFilter((String)"objectClass")), 0, 0, null, "dn");
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find sub-entries of entry '%s' for removal", dn));
            }
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to find sub-entries of entry '%s' for removal", dn), (Throwable)ex);
        }
        ArrayList<String> removeEntriesDn = new ArrayList<String>(searchResult.getEntryCount());
        for (SearchResultEntry searchResultEntry : searchResult.getSearchEntries()) {
            removeEntriesDn.add(searchResultEntry.getDN());
        }
        Collections.sort(removeEntriesDn, LINE_LENGHT_COMPARATOR);
        for (String removeEntryDn : removeEntriesDn) {
            this.remove(removeEntryDn);
        }
    }

    protected List<AttributeData> find(String dn, String ... ldapReturnAttributes) {
        try {
            SearchResultEntry entry = this.operationService.lookup(dn, ldapReturnAttributes);
            List<AttributeData> result = this.getAttributeDataList(entry);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn));
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, org.gluu.persist.model.SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        try {
            LdapBatchOperationWraper<T> batchOperationWraper = new LdapBatchOperationWraper<T>(batchOperation, this, entryClass, propertiesAnnotations);
            searchResult = this.operationService.search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(scope), batchOperationWraper, start, chunkSize, count, null, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        if (searchResult.getEntryCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        this.sortEntriesIfNeeded(entryClass, entries);
        return entries;
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        PagedResult vlvResponse = new PagedResult();
        try {
            searchResult = this.operationService.searchSearchResult(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(org.gluu.persist.model.SearchScope.SUB), start, count, chunkSize, sortBy, sortOrder, vlvResponse, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        if (searchResult.getEntryCount() == 0) {
            vlvResponse.setEntries(new ArrayList(0));
            return vlvResponse;
        }
        List<T> entries = this.createEntitiesVirtualListView(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        vlvResponse.setEntries(entries);
        return vlvResponse;
    }

    @Deprecated
    public <T> List<T> findEntriesVirtualListView(String baseDN, Class<T> entryClass, Filter filter, int start, int count, String sortBy, SortOrder sortOrder, PagedResult vlvResponse, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        SearchResult searchResult = null;
        try {
            searchResult = this.operationService.searchVirtualListView(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(org.gluu.persist.model.SearchScope.SUB), start, count, sortBy, sortOrder, vlvResponse, (String[])currentLdapReturnAttributes);
            if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        if (searchResult.getEntryCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntitiesVirtualListView(entryClass, propertiesAnnotations, searchResult.getSearchEntries().toArray(new SearchResultEntry[searchResult.getSearchEntries().size()]));
        return entries;
    }

    protected boolean contains(String baseDN, Filter filter, String[] objectClasses, String[] ldapReturnAttributes) {
        SearchResult searchResult;
        block4: {
            if (StringHelper.isEmptyString((Object)baseDN)) {
                throw new MappingException("Base DN to check contain entries is null");
            }
            Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
            searchResult = null;
            try {
                searchResult = this.operationService.search(baseDN, this.toLdapFilter(searchFilter), 1, 1, null, ldapReturnAttributes);
                if (searchResult == null || !ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                    throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter));
                }
            }
            catch (SearchException ex) {
                if (32 == ex.getResultCode()) break block4;
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
            }
        }
        return searchResult != null && searchResult.getEntryCount() > 0;
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, SearchResultEntry ... searchResultEntries) {
        ArrayList result = new ArrayList(searchResultEntries.length);
        HashMap<String, List<AttributeData>> entriesAttributes = new HashMap<String, List<AttributeData>>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            SearchResultEntry entry = searchResultEntries[i];
            entriesAttributes.put(entry.getDN(), this.getAttributeDataList(entry));
            searchResultEntries[i] = null;
            if (++count < 100) continue;
            List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new HashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    @Deprecated
    private <T> List<T> createEntitiesVirtualListView(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, SearchResultEntry ... searchResultEntries) {
        LinkedList result = new LinkedList();
        LinkedHashMap entriesAttributes = new LinkedHashMap(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            ++count;
            SearchResultEntry entry = searchResultEntries[i];
            LinkedList<AttributeData> attributeDataLinkedList = new LinkedList<AttributeData>();
            attributeDataLinkedList.addAll(this.getAttributeDataList(entry));
            entriesAttributes.put(entry.getDN(), attributeDataLinkedList);
            searchResultEntries[i] = null;
            if (count < 100) continue;
            LinkedList currentResult = new LinkedList();
            currentResult.addAll(this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false));
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false);
        result.addAll(currentResult);
        return result;
    }

    private List<AttributeData> getAttributeDataList(SearchResultEntry entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        for (Attribute attribute : entry.getAttributes()) {
            String[] attributeValueStrings = NO_STRINGS;
            String attributeName = attribute.getName();
            if (LOG.isTraceEnabled() && attribute.needsBase64Encoding()) {
                LOG.trace("Found binary attribute: " + attributeName + ". Is defined in LDAP config: " + this.operationService.isBinaryAttribute(attributeName));
            }
            attributeValueStrings = attribute.getValues();
            if (attribute.needsBase64Encoding()) {
                byte[][] attributeValues;
                boolean binaryAttribute = this.operationService.isBinaryAttribute(attributeName);
                boolean certificateAttribute = this.operationService.isCertificateAttribute(attributeName);
                if ((binaryAttribute || certificateAttribute) && (attributeValues = attribute.getValueByteArrays()) != null) {
                    attributeValueStrings = new String[attributeValues.length];
                    for (int i = 0; i < attributeValues.length; ++i) {
                        attributeValueStrings[i] = Base64.encodeBase64String((byte[])attributeValues[i]);
                        LOG.trace("Binary attribute: " + attribute.getName() + " value (hex): " + Hex.encodeHexString((byte[])attributeValues[i]) + " value (base64): " + attributeValueStrings[i]);
                    }
                }
                if (certificateAttribute) {
                    attributeName = this.operationService.getCertificateAttributeName(attributeName);
                }
            }
            AttributeData tmpAttribute = new AttributeData(attributeName, attributeValueStrings);
            result.add(tmpAttribute);
        }
        return result;
    }

    public boolean authenticate(String baseDN, String userName, String password) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"uid", (String)userName);
            SearchResult searchResult = this.operationService.search(baseDN, this.toLdapFilter(filter), 1, 1);
            if (searchResult == null || searchResult.getEntryCount() != 1) {
                return false;
            }
            String bindDn = ((SearchResultEntry)searchResult.getSearchEntries().get(0)).getDN();
            return this.operationService.authenticate(bindDn, password);
        }
        catch (ConnectionException ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: %s", userName), (Throwable)ex);
        }
        catch (SearchException ex) {
            throw new AuthenticationException(String.format("Failed to find user DN: %s", userName), (Throwable)ex);
        }
    }

    public boolean authenticate(String bindDn, String password) {
        try {
            return this.operationService.authenticate(bindDn, password);
        }
        catch (ConnectionException ex) {
            throw new AuthenticationException(String.format("Failed to authenticate DN: %s", bindDn), (Throwable)ex);
        }
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        String[] ldapReturnAttributes = new String[]{""};
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        CountBatchOperation batchOperation = new CountBatchOperation();
        try {
            LdapBatchOperationWraper batchOperationWraper = new LdapBatchOperationWraper(batchOperation);
            this.operationService.search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(org.gluu.persist.model.SearchScope.SUB), batchOperationWraper, 0, 100, 0, null, ldapReturnAttributes);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to calucalte count of entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return batchOperation.getCountEntries();
    }

    public String encodeGeneralizedTime(Date date) {
        if (date == null) {
            return null;
        }
        return StaticUtils.encodeGeneralizedTime((Date)date);
    }

    public Date decodeGeneralizedTime(String date) {
        if (date == null) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime((String)date);
        }
        catch (ParseException ex) {
            LOG.error("Failed to parse generalized time {}", (Object)date, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLdifFileContent(String ldifFileContent) {
        LDAPConnection connection = null;
        try {
            connection = this.operationService.getConnection();
            ResultCode result = LdifDataUtility.instance().importLdifFileContent(connection, ldifFileContent);
            boolean bl = ResultCode.SUCCESS.equals((Object)result);
            return bl;
        }
        catch (Exception ex) {
            LOG.error("Failed to load ldif file", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                this.operationService.releaseConnection(connection);
            }
        }
    }

    public String[] exportEntry(String dn) {
        String[] ldif = null;
        try {
            ldif = this.operationService.lookup(dn).toLDIF();
        }
        catch (ConnectionException e) {
            LOG.error("Failed get ldif from " + dn, (Throwable)e);
        }
        return ldif;
    }

    public int getSupportedLDAPVersion() {
        return this.operationService.getSupportedLDAPVersion();
    }

    private Modification createModification(ModificationType modificationType, String attributeName, String ... attributeValues) {
        String realAttributeName = attributeName;
        if (this.operationService.isCertificateAttribute(realAttributeName)) {
            realAttributeName = realAttributeName + ";binary";
            byte[][] binaryValues = this.toBinaryValues(attributeValues);
            return new Modification(modificationType, realAttributeName, binaryValues);
        }
        return new Modification(modificationType, realAttributeName, attributeValues);
    }

    private com.unboundid.ldap.sdk.Filter toLdapFilter(Filter genericFilter) throws SearchException {
        return LDAP_FILTER_CONVERTER.convertToLdapFilter(genericFilter);
    }

    private SearchScope toLdapSearchScope(org.gluu.persist.model.SearchScope scope) throws SearchScopeException {
        return LDAP_SEARCH_SCOPE_CONVERTER.convertToLdapSearchScope(scope);
    }

    private static final class CountBatchOperation<T>
    extends DefaultBatchOperation<T> {
        private int countEntries = 0;

        private CountBatchOperation() {
        }

        public void performAction(List<T> entries) {
        }

        public boolean collectSearchResult(int size) {
            this.countEntries += size;
            return false;
        }

        public int getCountEntries() {
            return this.countEntries;
        }
    }
}

