/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldif.LDIFChangeRecord;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.exception.ConnectionException;
import org.gluu.site.ldap.exception.DuplicateEntryException;
import org.gluu.site.ldap.exception.InvalidSimplePageControlException;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.exception.MappingException;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SortOrder;
import org.xdi.ldap.model.VirtualListViewResponse;
import org.xdi.util.ArrayHelper;
import org.xdi.util.Pair;
import org.xdi.util.StringHelper;

public class OperationsFacade {
    private static final Logger log = Logger.getLogger(OperationsFacade.class);
    public static final String dn = "dn";
    public static final String uid = "uid";
    public static final String success = "success";
    public static final String userPassword = "userPassword";
    public static final String objectClass = "objectClass";
    private LDAPConnectionProvider connectionProvider;
    private LDAPConnectionProvider bindConnectionProvider;
    private static Map<String, Class<?>> attributeDataTypes = new HashMap();
    private static final Map<String, Class<?>> oidSyntaxClassMapping = new HashMap();

    private OperationsFacade() {
    }

    @Deprecated
    public OperationsFacade(LDAPConnectionProvider connectionProvider) {
        this(connectionProvider, null);
    }

    public OperationsFacade(LDAPConnectionProvider connectionProvider, LDAPConnectionProvider bindConnectionProvider) {
        this.connectionProvider = connectionProvider;
        this.bindConnectionProvider = bindConnectionProvider;
        this.populateAttributeDataTypesMapping(this.getSubschemaSubentry());
    }

    public LDAPConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(LDAPConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public LDAPConnectionProvider getBindConnectionProvider() {
        return this.bindConnectionProvider;
    }

    public void setBindConnectionProvider(LDAPConnectionProvider bindConnectionProvider) {
        this.bindConnectionProvider = bindConnectionProvider;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionProvider.getConnectionPool();
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionProvider.getConnection();
    }

    public void releaseConnection(LDAPConnection connection) {
        this.connectionProvider.releaseConnection(connection);
    }

    public boolean authenticate(String userName, String password, String baseDN) throws ConnectionException {
        try {
            return this.authenticateImpl(userName, password, baseDN);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate user", ex);
        }
    }

    public boolean authenticate(String bindDn, String password) throws ConnectionException {
        try {
            return this.authenticateImpl(bindDn, password);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate dn", ex);
        }
    }

    private boolean authenticateImpl(String userName, String password, String baseDN) throws LDAPException, ConnectionException {
        return this.authenticateImpl(this.lookupDnByUid(userName, baseDN), password);
    }

    private boolean authenticateImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (this.bindConnectionProvider == null) {
            return this.authenticateConnectionPoolImpl(bindDn, password);
        }
        return this.authenticateBindConnectionPoolImpl(bindDn, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        boolean loggedIn = false;
        if (bindDn == null) {
            return loggedIn;
        }
        boolean closeConnection = false;
        LDAPConnection connection = this.connectionProvider.getConnection();
        try {
            closeConnection = true;
            BindResult r = connection.bind(bindDn, password);
            if (r.getResultCode() == ResultCode.SUCCESS) {
                loggedIn = true;
            }
        }
        finally {
            this.connectionProvider.releaseConnection(connection);
            if (closeConnection) {
                this.connectionProvider.closeDefunctConnection(connection);
            }
        }
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateBindConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (bindDn == null) {
            return false;
        }
        LDAPConnection connection = this.bindConnectionProvider.getConnection();
        try {
            BindResult r = connection.bind(bindDn, password);
            boolean bl = r.getResultCode() == ResultCode.SUCCESS;
            return bl;
        }
        finally {
            this.bindConnectionProvider.releaseConnection(connection);
        }
    }

    protected String lookupDnByUid(String uid, String baseDN) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter((String)uid, (String)uid);
        SearchResult searchResult = this.search(baseDN, filter, 1, 1);
        if (searchResult != null && searchResult.getEntryCount() > 0) {
            return ((SearchResultEntry)searchResult.getSearchEntries().get(0)).getDN();
        }
        return null;
    }

    public SearchResult search(String dn, Filter filter, int searchLimit, int sizeLimit) throws LDAPSearchException {
        return this.search(dn, filter, searchLimit, sizeLimit, null, (String[])null);
    }

    public SearchResult search(String dn, Filter filter, int searchLimit, int sizeLimit, Control[] controls, String ... attributes) throws LDAPSearchException {
        return this.search(dn, filter, SearchScope.SUB, searchLimit, sizeLimit, controls, attributes);
    }

    public SearchResult search(String dn, Filter filter, SearchScope scope, int searchLimit, int sizeLimit, Control[] controls, String ... attributes) throws LDAPSearchException {
        return this.search(dn, filter, scope, null, 0, searchLimit, sizeLimit, controls, attributes);
    }

    public SearchResult search(String dn, Filter filter, SearchScope scope, BatchOperation<?> batchOperation, int startIndex, int searchLimit, int sizeLimit, Control[] controls, String ... attributes) throws LDAPSearchException {
        boolean useSizeLimit;
        if (log.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            log.trace((Object)"Search in whole LDAP tree", (Throwable)new Exception());
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope.getLdapSearchScope(), filter, new String[0]) : new SearchRequest(dn, scope.getLdapSearchScope(), filter, attributes);
        boolean bl = useSizeLimit = sizeLimit > 0;
        if (useSizeLimit) {
            searchLimit = sizeLimit;
        }
        SearchResult searchResult = null;
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
        ArrayList searchResultEntries = new ArrayList();
        ArrayList searchResultReferences = new ArrayList();
        if (searchLimit > 0 || startIndex > 0) {
            if (searchLimit == 0) {
                searchLimit = 100;
            }
            LDAPConnection ldapConnection = null;
            try {
                ldapConnection = batchOperation != null ? batchOperation.getLdapConnection() : this.getConnectionPool().getConnection();
                ASN1OctetString cookie = null;
                if (startIndex > 0) {
                    try {
                        cookie = this.scrollSimplePagedResultsControl(ldapConnection, dn, filter, scope, controls, startIndex);
                    }
                    catch (InvalidSimplePageControlException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified startIndex", (Throwable)ex);
                    }
                    catch (LDAPException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified startIndex", (Throwable)ex);
                    }
                }
                if (batchOperation != null) {
                    cookie = batchOperation.getCookie();
                }
                do {
                    searchRequest.setControls(new Control[]{new SimplePagedResultsControl(searchLimit, cookie)});
                    this.setControls(searchRequest, controls);
                    searchResult = ldapConnection.search(searchRequest);
                    if (batchOperation == null || batchOperation.collectSearchResult(searchResult)) {
                        searchResultList.add(searchResult);
                        searchResultEntries.addAll(searchResult.getSearchEntries());
                        searchResultReferences.addAll(searchResult.getSearchReferences());
                    }
                    if (batchOperation != null) {
                        batchOperation.processSearchResult(searchResult);
                    }
                    cookie = null;
                    try {
                        SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                        if (c != null) {
                            cookie = c.getCookie();
                            if (batchOperation != null) {
                                batchOperation.setCookie(cookie);
                                batchOperation.setMoreResultsToReturn(c.moreResultsToReturn());
                            }
                        }
                    }
                    catch (LDAPException ex) {
                        log.error((Object)("Error while accessing cookies" + ex.getMessage()));
                    }
                    if (!useSizeLimit) continue;
                    break;
                } while (cookie != null && cookie.getValueLength() > 0);
            }
            catch (LDAPException e) {
                throw new LDAPSearchException(e.getResultCode(), "Failed to scroll to specified startIndex", (Throwable)e);
            }
            finally {
                if (ldapConnection != null) {
                    if (batchOperation != null) {
                        if (!batchOperation.isMoreResultsToReturn()) {
                            batchOperation.releaseConnection();
                        }
                    } else {
                        this.getConnectionPool().releaseConnection(ldapConnection);
                    }
                }
            }
            if (!searchResultList.isEmpty()) {
                SearchResult searchResultTemp = (SearchResult)searchResultList.get(0);
                searchResult = new SearchResult(searchResultTemp.getMessageID(), searchResultTemp.getResultCode(), searchResultTemp.getDiagnosticMessage(), searchResultTemp.getMatchedDN(), searchResultTemp.getReferralURLs(), searchResultEntries, searchResultReferences, searchResultEntries.size(), searchResultReferences.size(), searchResultTemp.getResponseControls());
            }
        } else {
            this.setControls(searchRequest, controls);
            searchResult = this.getConnectionPool().search(searchRequest);
        }
        return searchResult;
    }

    private ASN1OctetString scrollSimplePagedResultsControl(LDAPConnection ldapConnection, String dn, Filter filter, SearchScope scope, Control[] controls, int startIndex) throws LDAPException, InvalidSimplePageControlException {
        SearchRequest searchRequest = new SearchRequest(dn, scope.getLdapSearchScope(), filter, new String[]{dn});
        int currentStartIndex = startIndex;
        ASN1OctetString cookie = null;
        do {
            int pageSize = Math.min(currentStartIndex, 100);
            searchRequest.setControls(new Control[]{new SimplePagedResultsControl(pageSize, cookie, true)});
            this.setControls(searchRequest, controls);
            SearchResult searchResult = ldapConnection.search(searchRequest);
            currentStartIndex -= searchResult.getEntryCount();
            try {
                SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                if (c == null) continue;
                cookie = c.getCookie();
            }
            catch (LDAPException ex) {
                log.error((Object)"Error while accessing cookie", (Throwable)ex);
                throw new InvalidSimplePageControlException(ex.getResultCode(), "Error while accessing cookie");
            }
        } while (cookie != null && cookie.getValueLength() > 0 && currentStartIndex > 0);
        return cookie;
    }

    public List<SearchResultEntry> searchSearchResultEntryList(String dn, Filter filter, SearchScope scope, int startIndex, int count, int pageSize, String sortBy, SortOrder sortOrder, VirtualListViewResponse vlvResponse, String ... attributes) throws Exception {
        List searchEntries;
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        ASN1OctetString resumeCookie = null;
        LDAPConnection conn = this.getConnection();
        SearchRequest searchRequest = new SearchRequest(dn, scope.getLdapSearchScope(), filter, attributes);
        int totalResults = 0;
        int start = startIndex - 1;
        do {
            SearchResult searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
            searchEntries = searchResult.getSearchEntries();
            resumeCookie = this.getSearchResultCookie(searchResult);
        } while ((totalResults += searchEntries.size()) < start && resumeCookie != null);
        List<SearchResultEntry> searchResultEntryList = new ArrayList();
        if (totalResults > start) {
            int lowerBound = searchEntries.size() - (totalResults - start);
            int upperBound = Math.min(searchEntries.size(), lowerBound + count);
            searchResultEntryList.addAll(searchEntries.subList(lowerBound, upperBound));
        }
        while (resumeCookie != null && totalResults < count + start) {
            SearchResult searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
            searchEntries = searchResult.getSearchEntries();
            searchResultEntryList.addAll(searchEntries);
            totalResults += searchEntries.size();
            resumeCookie = this.getSearchResultCookie(searchResult);
        }
        if (totalResults > count + start) {
            searchResultEntryList = searchResultEntryList.subList(0, count);
        }
        while (resumeCookie != null) {
            SearchResult searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
            searchEntries = searchResult.getSearchEntries();
            totalResults += searchEntries.size();
            resumeCookie = this.getSearchResultCookie(searchResult);
        }
        if (StringUtils.isNotEmpty((String)sortBy)) {
            boolean ascending = sortOrder == null || sortOrder.equals((Object)SortOrder.ASCENDING);
            searchResultEntryList = this.sortListByAttributes(searchResultEntryList, SearchResultEntry.class, false, ascending, sortBy);
        }
        vlvResponse.setItemsPerPage(searchResultEntryList.size());
        vlvResponse.setTotalResults(totalResults);
        vlvResponse.setStartIndex(startIndex);
        this.releaseConnection(conn);
        return searchResultEntryList;
    }

    private ASN1OctetString getSearchResultCookie(SearchResult searchResult) throws Exception {
        SimplePagedResultsControl responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
        return responseControl.moreResultsToReturn() ? responseControl.getCookie() : null;
    }

    private SearchResult nextSearchResult(LDAPConnection connection, SearchRequest searchRequest, int pageSize, ASN1OctetString resumeCookie) throws Exception {
        searchRequest.setControls(new Control[]{new SimplePagedResultsControl(pageSize, resumeCookie)});
        SearchResult result = connection.search(searchRequest);
        if (!ResultCode.SUCCESS.equals((Object)result.getResultCode())) {
            String msgErr = "Search operation returned: " + result.getResultCode();
            log.error((Object)msgErr);
            throw new Exception(msgErr);
        }
        return result;
    }

    public SearchResult searchVirtualListView(String dn, Filter filter, SearchScope scope, int startIndex, int count, String sortBy, SortOrder sortOrder, VirtualListViewResponse vlvResponse, String ... attributes) throws Exception {
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope.getLdapSearchScope(), filter, new String[0]) : new SearchRequest(dn, scope.getLdapSearchScope(), filter, attributes);
        int targetOffset = startIndex;
        int beforeCount = 0;
        int afterCount = count > 0 ? count - 1 : 0;
        int contentCount = 0;
        boolean reverseOrder = false;
        if (sortOrder != null) {
            reverseOrder = sortOrder.equals((Object)SortOrder.DESCENDING);
        }
        searchRequest.setControls(new Control[]{new ServerSideSortRequestControl(new SortKey[]{new SortKey(sortBy, reverseOrder)}), new VirtualListViewRequestControl(targetOffset, beforeCount, afterCount, contentCount, null)});
        SearchResult searchResult = this.getConnectionPool().search(searchRequest);
        VirtualListViewResponseControl vlvResponseControl = VirtualListViewResponseControl.get((SearchResult)searchResult);
        vlvResponse.setItemsPerPage(searchResult.getEntryCount());
        vlvResponse.setTotalResults(vlvResponseControl.getContentCount());
        vlvResponse.setStartIndex(vlvResponseControl.getTargetPosition());
        return searchResult;
    }

    private void setControls(SearchRequest searchRequest, Control ... controls) {
        if (!ArrayHelper.isEmpty((Object[])controls)) {
            Control[] newControls = ArrayHelper.isEmpty((Object[])searchRequest.getControls()) ? controls : (Control[])ArrayHelper.arrayMerge((Object[][])new Control[][]{searchRequest.getControls(), controls});
            searchRequest.setControls(newControls);
        }
    }

    public SearchResultEntry lookup(String dn) throws ConnectionException {
        return this.lookup(dn, null);
    }

    public SearchResultEntry lookup(String dn, String ... attributes) throws ConnectionException {
        if (StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            new Exception().printStackTrace();
        }
        try {
            if (attributes == null) {
                return this.getConnectionPool().getEntry(dn);
            }
            return this.getConnectionPool().getEntry(dn, attributes);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to lookup entry", ex);
        }
    }

    public boolean addEntry(String dn, Collection<Attribute> atts) throws DuplicateEntryException, ConnectionException {
        try {
            LDAPResult result = this.getConnectionPool().add(dn, atts);
            if (result.getResultCode().getName().equalsIgnoreCase(success)) {
                return true;
            }
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 68) {
                throw new DuplicateEntryException();
            }
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", ex);
            }
            throw new ConnectionException("Error adding entry to directory. LDAP error number " + errorCode, ex);
        }
        return false;
    }

    public boolean updateEntry(String dn, Collection<Attribute> attrs) throws DuplicateEntryException, ConnectionException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute attribute : attrs) {
            if (attribute.getName().equalsIgnoreCase(objectClass) || attribute.getName().equalsIgnoreCase(dn) || attribute.getName().equalsIgnoreCase(userPassword) || attribute.getName() == null || attribute.getValue() == null) continue;
            mods.add(new Modification(ModificationType.REPLACE, attribute.getName(), attribute.getValue()));
        }
        return this.updateEntry(dn, (List<Modification>)mods);
    }

    public boolean updateEntry(String dn, List<Modification> modifications) throws DuplicateEntryException, ConnectionException {
        ModifyRequest modifyRequest = new ModifyRequest(dn, modifications);
        return this.modifyEntry(modifyRequest);
    }

    protected boolean modifyEntry(ModifyRequest modifyRequest) throws DuplicateEntryException, ConnectionException {
        LDAPResult modifyResult = null;
        try {
            modifyResult = this.getConnectionPool().modify(modifyRequest);
            return ResultCode.SUCCESS.equals((Object)modifyResult.getResultCode());
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", ex);
            }
            throw new ConnectionException("Error updating entry in directory. LDAP error number " + errorCode, ex);
        }
    }

    public void delete(String dn) throws ConnectionException {
        try {
            this.getConnectionPool().delete(dn);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", ex);
        }
    }

    public void deleteWithSubtree(String dn) throws ConnectionException {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            deleteRequest.addControl((Control)new SubtreeDeleteRequestControl());
            this.getConnectionPool().delete(deleteRequest);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processChange(LDIFChangeRecord ldifRecord) throws LDAPException {
        LDAPConnection connection = this.getConnection();
        try {
            LDAPResult ldapResult = ldifRecord.processChange((LDAPInterface)connection);
            boolean bl = ResultCode.SUCCESS.equals((Object)ldapResult.getResultCode());
            return bl;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    public int getSupportedLDAPVersion() {
        return this.connectionProvider.getSupportedLDAPVersion();
    }

    public String getSubschemaSubentry() {
        return this.connectionProvider.getSubschemaSubentry();
    }

    public boolean destroy() {
        boolean result = true;
        try {
            this.connectionProvider.closeConnectionPool();
        }
        catch (Exception ex) {
            log.error((Object)"Failed to close connection pool correctly");
            result = false;
        }
        if (this.bindConnectionProvider != null) {
            try {
                this.bindConnectionProvider.closeConnectionPool();
            }
            catch (Exception ex) {
                log.error((Object)"Failed to close bind connection pool correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isBinaryAttribute(String attributeName) {
        return this.connectionProvider.isBinaryAttribute(attributeName);
    }

    public boolean isCertificateAttribute(String attributeName) {
        return this.connectionProvider.isCertificateAttribute(attributeName);
    }

    public String getCertificateAttributeName(String attributeName) {
        return this.connectionProvider.getCertificateAttributeName(attributeName);
    }

    public <T> List<T> sortListByAttributes(List<T> searchResultEntries, Class<T> cls, boolean caseSensitive, boolean ascending, String ... sortByAttributes) {
        if (searchResultEntries == null) {
            throw new MappingException("Entries list to sort is null");
        }
        if (searchResultEntries.size() == 0) {
            return searchResultEntries;
        }
        SearchResultEntryComparator comparator = new SearchResultEntryComparator(sortByAttributes, caseSensitive, ascending);
        Object[] dummyArr = (Object[])Array.newInstance(cls, 0);
        Object[] array = searchResultEntries.toArray(dummyArr);
        Arrays.sort(array, comparator);
        return Arrays.asList(array);
    }

    private void populateAttributeDataTypesMapping(String schemaEntryDn) {
        try {
            if (attributeDataTypes.size() == 0) {
                SearchResultEntry entry = this.lookup(schemaEntryDn, "attributeTypes");
                Attribute attrAttributeTypes = entry.getAttribute("attributeTypes");
                HashMap<String, Pair> tmpMap = new HashMap<String, Pair>();
                for (String strAttributeType : attrAttributeTypes.getValues()) {
                    AttributeTypeDefinition attrTypeDef = new AttributeTypeDefinition(strAttributeType);
                    String[] names = attrTypeDef.getNames();
                    if (names == null) continue;
                    for (String name : names) {
                        tmpMap.put(name, new Pair((Object)attrTypeDef.getBaseSyntaxOID(), (Object)attrTypeDef.getSuperiorType()));
                    }
                }
                for (String name : tmpMap.keySet()) {
                    Pair pair;
                    Pair currPair = (Pair)tmpMap.get(name);
                    String sup = (String)currPair.getSecond();
                    if (currPair.getFirst() != null || sup == null || (pair = (Pair)tmpMap.get(sup)) == null) continue;
                    currPair.setFirst(pair.getFirst());
                }
                for (String name : tmpMap.keySet()) {
                    Class<?> cls;
                    String syntaxOID = (String)((Pair)tmpMap.get(name)).getFirst();
                    if (syntaxOID == null || (cls = oidSyntaxClassMapping.get(syntaxOID)) == null) continue;
                    attributeDataTypes.put(name, cls);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.7", Boolean.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.11", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.15", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.12", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.22", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.24", Date.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.26", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.27", Integer.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.36", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.41", String.class);
        oidSyntaxClassMapping.put("1.3.6.1.4.1.1466.115.121.1.50", String.class);
    }

    private static final class SearchResultEntryComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 574848841116711467L;
        private String[] sortByAttributes;
        private boolean caseSensitive;
        private boolean ascending;

        private SearchResultEntryComparator(String[] sortByAttributes, boolean caseSensitive, boolean ascending) {
            this.sortByAttributes = sortByAttributes;
            this.caseSensitive = caseSensitive;
            this.ascending = ascending;
        }

        @Override
        public int compare(T entry1, T entry2) {
            int result = 0;
            if (entry1 == null) {
                result = entry2 == null ? 0 : -1;
            } else if (entry2 == null) {
                result = 1;
            } else {
                String currSortByAttribute;
                String[] stringArray = this.sortByAttributes;
                int n = stringArray.length;
                for (int i = 0; i < n && (result = this.compare(entry1, entry2, currSortByAttribute = stringArray[i])) == 0; ++i) {
                }
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public int compare(T entry1, T entry2, String attributeName) {
            int result = 0;
            try {
                if (entry1 instanceof SearchResultEntry) {
                    SearchResultEntry resultEntry1 = (SearchResultEntry)entry1;
                    SearchResultEntry resultEntry2 = (SearchResultEntry)entry2;
                    String value1 = resultEntry1.getAttributeValue(attributeName);
                    String value2 = resultEntry2.getAttributeValue(attributeName);
                    if (value1 == null) {
                        result = value2 == null ? 0 : -1;
                    } else if (value2 == null) {
                        result = 1;
                    } else {
                        Class cls = (Class)attributeDataTypes.get(attributeName);
                        if (cls != null) {
                            if (cls.equals(String.class)) {
                                result = this.caseSensitive ? value1.compareTo(value2) : value1.toLowerCase().compareTo(value2.toLowerCase());
                            } else if (cls.equals(Integer.class)) {
                                result = resultEntry1.getAttributeValueAsInteger(attributeName).compareTo(resultEntry2.getAttributeValueAsInteger(attributeName));
                            } else if (cls.equals(Boolean.class)) {
                                result = resultEntry1.getAttributeValueAsBoolean(attributeName).compareTo(resultEntry2.getAttributeValueAsBoolean(attributeName));
                            } else if (cls.equals(Date.class)) {
                                result = resultEntry1.getAttributeValueAsDate(attributeName).compareTo(resultEntry2.getAttributeValueAsDate(attributeName));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred when comparing entries with SearchResultEntryComparator");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return result;
        }
    }
}

