/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.ldap.model;

import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAttribute
implements Serializable,
Comparable<CustomAttribute> {
    private static final long serialVersionUID = 1468450094325306154L;
    private static final Logger log = LoggerFactory.getLogger(CustomAttribute.class);
    private String name;
    private List<String> values;

    public CustomAttribute() {
    }

    public CustomAttribute(String name) {
        this.name = name;
    }

    public CustomAttribute(String name, String value) {
        this.name = name;
        this.setValue(value);
    }

    public CustomAttribute(String name, Date value) {
        this.name = name;
        this.setDate(value);
    }

    public CustomAttribute(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public String getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public void setValue(String value) {
        this.values = new ArrayList<String>();
        this.values.add(value);
    }

    public Date getDate() {
        if (this.values == null) {
            return null;
        }
        if (!this.values.isEmpty()) {
            try {
                return StaticUtils.decodeGeneralizedTime((String)this.values.get(0));
            }
            catch (ParseException e) {
                log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void setDate(Date date) {
        this.values = new ArrayList<String>();
        this.values.add(StaticUtils.encodeGeneralizedTime((Date)date));
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getDisplayValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        StringBuilder sb = new StringBuilder(this.values.get(0));
        for (int i = 1; i < this.values.size(); ++i) {
            sb.append(", ").append(this.values.get(i));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAttribute that = (CustomAttribute)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, values=%s]", this.name, this.values);
    }

    @Override
    public int compareTo(CustomAttribute o) {
        return this.name.compareTo(o.name);
    }
}

