/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.site.ldap.persistence;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;

public abstract class BatchOperation<T> {
    private ASN1OctetString cookie;
    private LDAPConnection ldapConnection;
    private LDAPConnectionPool ldapConnectionPool;
    private boolean moreResultsToReturn;

    protected abstract List<T> getChunkOrNull(int var1);

    protected abstract void performAction(List<T> var1);

    public BatchOperation(LdapEntryManager ldapEntryManager) {
        this.ldapConnectionPool = ldapEntryManager.getLdapOperationService().getConnectionPool();
        try {
            this.ldapConnection = this.ldapConnectionPool.getConnection();
        }
        catch (LDAPException e) {
            Debug.debugException((Throwable)e);
            this.ldapConnection = null;
        }
    }

    public void iterateAllByChunks(int batchSize) {
        if (this.ldapConnection == null) {
            return;
        }
        try {
            List<T> objects;
            while (!CollectionUtils.isEmpty(objects = this.getChunkOrNull(batchSize))) {
                this.performAction(objects);
                if (objects.size() >= batchSize && this.moreResultsToReturn) continue;
                break;
            }
        }
        finally {
            this.ldapConnectionPool.releaseConnection(this.ldapConnection);
        }
    }

    public ASN1OctetString getCookie() {
        return this.cookie;
    }

    public void setCookie(ASN1OctetString cookie) {
        this.cookie = cookie;
    }

    public void setMoreResultsToReturn(boolean moreResultsToReturn) {
        this.moreResultsToReturn = moreResultsToReturn;
    }

    public LDAPConnection getLdapConnection() {
        return this.ldapConnection;
    }
}

