/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.ldap.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.BaseEntry;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.util.StringHelper;

@LdapEntry
@LdapObjectClass(values={"top"})
public class CustomEntry
extends BaseEntry
implements Serializable {
    private static final long serialVersionUID = -7686468010219068788L;
    @LdapAttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @LdapCustomObjectClass
    private String[] customObjectClasses;

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public String getCustomAttributeValue(String attributeName) {
        if (this.customAttributes == null) {
            return null;
        }
        for (CustomAttribute customAttribute : this.customAttributes) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute.getValue();
        }
        return null;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

