/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.service.cdi.util.CdiUtil;
import org.xdi.util.ArrayHelper;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);

    private ServerUtil() {
    }

    public static String asJsonSilently(Object p_object) {
        try {
            return ServerUtil.asJson(p_object);
        }
        catch (IOException e) {
            log.trace(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static boolean isTrue(Boolean booleanObject) {
        return booleanObject != null && booleanObject != false;
    }

    public static boolean isFalse(Boolean booleanObject) {
        return !ServerUtil.isTrue(booleanObject);
    }

    public static String asPrettyJson(Object p_object) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(p_object);
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static CacheControl cacheControl(boolean p_noStore) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(p_noStore);
        return cacheControl;
    }

    public static CacheControl cacheControl(boolean p_noStore, boolean p_noTransform) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(p_noStore);
        cacheControl.setNoTransform(p_noTransform);
        return cacheControl;
    }

    public static ObjectMapper createJsonMapper() {
        JaxbAnnotationIntrospector jaxb = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair pair = new AnnotationIntrospector.Pair((AnnotationIntrospector)jackson, (AnnotationIntrospector)jaxb);
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)pair);
        return mapper;
    }

    public static ObjectMapper jsonMapperWithWrapRoot() {
        return ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
    }

    public static ObjectMapper jsonMapperWithUnwrapRoot() {
        return ServerUtil.createJsonMapper().configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
    }

    public static LdapEntryManager getLdapManager() {
        return (LdapEntryManager)CdiUtil.bean(LdapEntryManager.class, (String)"ldapEntryManager");
    }

    public static CustomAttribute getAttributeByName(List<CustomAttribute> p_list, String p_attributeName) {
        if (p_list != null && !p_list.isEmpty() && StringUtils.isNotEmpty((String)p_attributeName)) {
            for (CustomAttribute attr : p_list) {
                if (!p_attributeName.equals(attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    public static String getAttributeValueByName(List<CustomAttribute> p_list, String p_attributeName) {
        CustomAttribute attr = ServerUtil.getAttributeByName(p_list, p_attributeName);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public static String urlDecode(String p_str) {
        if (StringUtils.isNotBlank((String)p_str)) {
            try {
                return URLDecoder.decode(p_str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return p_str;
    }

    public static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable p_r) {
                Thread thread = new Thread(p_r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static org.xdi.oxauth.model.uma.UmaPermission convert(UmaPermission permission, UmaScopeService umaScopeService) {
        if (permission != null) {
            org.xdi.oxauth.model.uma.UmaPermission result = new org.xdi.oxauth.model.uma.UmaPermission();
            result.setResourceId(permission.getResourceId());
            result.setScopes(umaScopeService.getScopeIdsByDns(permission.getScopeDns()));
            result.setExpiresAt(ServerUtil.dateToSeconds(permission.getExpirationDate()));
            return result;
        }
        return null;
    }

    public static String getFirstValue(Map<String, String[]> map, String key) {
        Object[] values;
        if (map.containsKey(key) && ArrayHelper.isNotEmpty((Object[])(values = map.get(key)))) {
            return values[0];
        }
        return null;
    }

    public static String getIpAddress(HttpServletRequest httpRequest) {
        String[] HEADERS_TO_TRY;
        for (String header : HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"}) {
            String ip = httpRequest.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return httpRequest.getRemoteAddr();
    }

    public static HttpServletRequest getRequestOrNull() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext == null) {
            return null;
        }
        Object request = externalContext.getRequest();
        if (request == null || !(request instanceof HttpServletRequest)) {
            return null;
        }
        return (HttpServletRequest)request;
    }

    public static boolean isSameRequestPath(String url1, String url2) throws MalformedURLException {
        if (url1 == null || url2 == null) {
            return false;
        }
        URL parsedUrl1 = new URL(url1);
        URL parsedUrl2 = new URL(url2);
        return parsedUrl1.getPath().endsWith(parsedUrl2.getPath());
    }

    public static Integer dateToSeconds(Date date) {
        return date != null ? Integer.valueOf((int)(date.getTime() / 1000L)) : null;
    }
}

