/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.net.MalformedURLException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.model.common.ResponseMode;
import org.xdi.oxauth.util.RedirectUri;

public class RedirectUtil {
    private static final Logger log = LoggerFactory.getLogger(RedirectUtil.class);
    static String JSON_REDIRECT_PROPNAME = "redirect";
    static String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";
    static int HTTP_REDIRECT = 302;

    public static Response.ResponseBuilder getRedirectResponseBuilder(RedirectUri redirectUriResponse, HttpServletRequest httpRequest) {
        ResponseBuilderImpl builder;
        if (httpRequest != null && httpRequest.getHeader(NO_REDIRECT_HEADER) != null) {
            try {
                URI redirectURI = URI.create(redirectUriResponse.toString());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(JSON_REDIRECT_PROPNAME, (Object)redirectURI.toURL());
                String jsonResp = jsonObject.toString();
                jsonResp = jsonResp.replace("\\/", "/");
                builder = Response.ok((Object)new GenericEntity((Object)jsonResp, String.class), (MediaType)MediaType.APPLICATION_JSON_TYPE);
            }
            catch (MalformedURLException e) {
                builder = Response.serverError();
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                builder = Response.serverError();
                log.debug(e.getMessage(), (Throwable)e);
            }
        } else if (redirectUriResponse.getResponseMode() != ResponseMode.FORM_POST) {
            URI redirectURI = URI.create(redirectUriResponse.toString());
            builder = new ResponseBuilderImpl();
            builder = Response.status((int)HTTP_REDIRECT);
            builder.location(redirectURI);
        } else {
            builder = new ResponseBuilderImpl();
            builder.status(Response.Status.OK);
            builder.type(MediaType.TEXT_HTML_TYPE);
            builder.cacheControl(CacheControl.valueOf((String)"no-cache, no-store"));
            builder.header("Pragma", (Object)"no-cache");
            builder.entity((Object)redirectUriResponse.toString());
        }
        return builder;
    }
}

