/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUtils {
    private static final Logger log = LoggerFactory.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static boolean isDN(String p_dn) {
        return DN.isValidDN((String)p_dn);
    }

    public static boolean isValidDNs(String ... p_dnList) {
        return LdapUtils.isValidDNs(p_dnList != null ? Arrays.asList(p_dnList) : null);
    }

    public static boolean isValidDNs(List<String> p_dnList) {
        if (p_dnList != null) {
            for (String dn : p_dnList) {
                if (LdapUtils.isDN(dn)) continue;
                return false;
            }
        }
        return true;
    }

    public static Filter createAnyFilterFromDnList(String p_filterAttributeName, List<String> p_dnList) {
        try {
            if (p_dnList != null && !p_dnList.isEmpty()) {
                StringBuilder sb = new StringBuilder("(|");
                for (String dn : p_dnList) {
                    String[] values;
                    DN dnObj = new DN(dn);
                    RDN rdn = dnObj.getRDN();
                    if (!rdn.getAttributeNames()[0].equals(p_filterAttributeName) || (values = rdn.getAttributeValues()) == null || values.length != 1) continue;
                    sb.append("(");
                    sb.append(p_filterAttributeName).append("=");
                    sb.append(values[0]);
                    sb.append(")");
                }
                sb.append(")");
                String filterAsString = sb.toString();
                log.trace("dnList: " + p_dnList + ", ldapFilter: " + filterAsString);
                return Filter.create((String)filterAsString);
            }
        }
        catch (LDAPException e) {
            log.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

