/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.crypto.cert.CertificateParser;
import org.xdi.util.StringHelper;

public class CertUtil {
    private static final Logger log = LoggerFactory.getLogger(CertUtil.class);

    private CertUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<X509Certificate> loadX509CertificateFromFile(String filePath) {
        FileInputStream is;
        if (StringHelper.isEmpty((String)filePath)) {
            log.error("X509Certificate file path is empty");
            return null;
        }
        try {
            is = FileUtils.openInputStream((File)new File(filePath));
        }
        catch (IOException ex) {
            log.error("Failed to read X.509 certificates from file: '" + filePath + "'", (Throwable)ex);
            return null;
        }
        List certificates = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificates = (List)cf.generateCertificates(is);
        }
        catch (CertificateException ex) {
            log.error("Failed to parse X.509 certificates from file: '" + filePath + "'", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return certificates;
    }

    public static X509Certificate x509CertificateFromBytes(byte[] cert) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            return (X509Certificate)certFactory.generateCertificate(bais);
        }
        catch (CertificateException ex) {
            log.error("Failed to parse X.509 certificates from bytes", (Throwable)ex);
            return null;
        }
    }

    public static X509Certificate parsePem(String pem) {
        try {
            return CertificateParser.parsePem(pem);
        }
        catch (CertificateException ex) {
            log.error("Failed to parse PEM certificate", (Throwable)ex);
            return null;
        }
    }
}

