/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.userinfo.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Api(value="/", description="The UserInfo Endpoint is an OAuth 2.0 Protected Resource that returns Claims about the authenticated End-User. To obtain the requested Claims about the End-User, the Client makes a request to the UserInfo Endpoint using an Access Token obtained through OpenID Connect Authentication. These Claims are normally represented by a JSON object that contains a collection of name and value pairs for the Claims. ")
public interface UserInfoRestWebService {
    @GET
    @Path(value="/userinfo")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns Claims about the authenticated End-User.", notes="The Access Token obtained from an OpenID Connect Authentication Request is sent as a Bearer Token.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\nThe request is missing a required parameter, includes an unsupported parameter or parameter value, repeats the same parameter, uses more than one method for including an access token, or is otherwise malformed.  The resource server SHOULD respond with the HTTP 400 (Bad Request) status code."), @ApiResponse(code=401, message="invalid_token\nThe access token provided is expired, revoked, malformed, or invalid for other reasons.  The resource SHOULD respond with the HTTP 401 (Unauthorized) status code.  The client MAY request a new access token and retry the protected resource request."), @ApiResponse(code=403, message="insufficient_scope\nThe request requires higher privileges than provided by the access token.  The resource server SHOULD respond with the HTTP 403 (Forbidden) status code and MAY include the \"scope\"\n attribute with the scope necessary to access the protected resource.")})
    public Response requestUserInfoGet(@QueryParam(value="access_token") @ApiParam(value="OAuth 2.0 Access Token.", required=true) String var1, @HeaderParam(value="Authorization") String var2, @Context HttpServletRequest var3, @Context SecurityContext var4);

    @POST
    @Path(value="/userinfo")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns Claims about the authenticated End-User.", notes="The Access Token obtained from an OpenID Connect Authentication Request is sent as a Bearer Token.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\nThe request is missing a required parameter, includes an unsupported parameter or parameter value, repeats the same parameter, uses more than one method for including an access token, or is otherwise malformed.  The resource server SHOULD respond with the HTTP 400 (Bad Request) status code."), @ApiResponse(code=401, message="invalid_token\nThe access token provided is expired, revoked, malformed, or invalid for other reasons.  The resource SHOULD respond with the HTTP 401 (Unauthorized) status code.  The client MAY request a new access token and retry the protected resource request."), @ApiResponse(code=403, message="insufficient_scope\nThe request requires higher privileges than provided by the access token.  The resource server SHOULD respond with the HTTP 403 (Forbidden) status code and MAY include the \"scope\"\n attribute with the scope necessary to access the protected resource.")})
    public Response requestUserInfoPost(@FormParam(value="access_token") @ApiParam(value="OAuth 2.0 Access Token.", required=true) String var1, @HeaderParam(value="Authorization") String var2, @Context HttpServletRequest var3, @Context SecurityContext var4);
}

