/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.UmaScopeDescription;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/uma/scopes")
@Api(value="/uma/scopes", description="UMA Scope Endpoint provides scope description (json document) by scope id.")
public class UmaScopeWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaScopeService umaScopeService;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getScopeDescription(@PathParam(value="id") String id) {
        this.log.trace("UMA - get scope description: id: {}", (Object)id);
        try {
            org.xdi.oxauth.model.uma.persistence.UmaScopeDescription scope;
            if (StringUtils.isNotBlank((String)id) && (scope = this.umaScopeService.getScope(id)) != null) {
                UmaScopeDescription jsonScope = new UmaScopeDescription();
                jsonScope.setIconUri(scope.getIconUrl());
                jsonScope.setName(scope.getDisplayName());
                jsonScope.setDescription(scope.getDescription());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(jsonScope)).build();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
    }
}

