/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.model.GluuImage;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.service.XmlService;

@Path(value="/uma/scopes/icons")
@Api(value="/uma/scopes/icons", description="UMA Scope Icon endpoint provides scope icon by scope id.")
public class UmaScopeIconWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private XmlService xmlService;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getScopeDescription(@PathParam(value="id") String id) {
        this.log.trace("UMA - get scope's icon : id: {}", (Object)id);
        try {
            GluuImage gluuImage;
            UmaScopeDescription scope;
            if (StringUtils.isNotBlank((String)id) && (scope = this.umaScopeService.getScope(id)) != null && StringUtils.isNotBlank((String)scope.getFaviconImageAsXml()) && (gluuImage = this.xmlService.getGluuImageFromXML(scope.getFaviconImageAsXml())) != null && ArrayUtils.isNotEmpty((byte[])gluuImage.getData())) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)gluuImage.getData()).build();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
    }
}

