/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.RptIntrospectionResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.authorization.UmaRPT;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaRptService;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.oxauth.uma.service.UmaValidationService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Path(value="/rpt/status")
@Api(value="/rpt/status", description="The endpoint at which the host requests the status of an RPT presented to it by a requester. The endpoint is RPT introspection profile implementation defined by UMA specification")
public class UmaRptIntrospectionWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private UmaPctService pctService;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="token") String token, @QueryParam(value="token_type_hint") String tokenTypeHint) {
        return this.introspect(authorization, token, tokenTypeHint);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint) {
        return this.introspect(authorization, token, tokenTypeHint);
    }

    private Response introspect(String authorization, String token, String tokenTypeHint) {
        try {
            this.umaValidationService.assertHasProtectionScope(authorization);
            UmaRPT rpt = this.rptService.getRPTByCode(token);
            if (!this.isValid(rpt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RptIntrospectionResponse(false)).cacheControl(ServerUtil.cacheControl(true)).build();
            }
            List<org.xdi.oxauth.model.uma.UmaPermission> permissions = this.buildStatusResponsePermissions(rpt);
            RptIntrospectionResponse statusResponse = new RptIntrospectionResponse();
            statusResponse.setActive(true);
            statusResponse.setExpiresAt(ServerUtil.dateToSeconds(rpt.getExpirationDate()));
            statusResponse.setIssuedAt(ServerUtil.dateToSeconds(rpt.getCreationDate()));
            statusResponse.setPermissions(permissions);
            statusResponse.setClientId(rpt.getClientId());
            statusResponse.setAud(rpt.getClientId());
            statusResponse.setSub(rpt.getUserId());
            List<UmaPermission> rptPermissions = this.rptService.getRptPermissions(rpt);
            if (!rptPermissions.isEmpty()) {
                UmaPermission permission = rptPermissions.iterator().next();
                String pctCode = (String)permission.getAttributes().get("pct");
                if (StringHelper.isNotEmpty((String)pctCode)) {
                    UmaPCT pct = this.pctService.getByCode(pctCode);
                    if (pct != null) {
                        statusResponse.setPctClaims(pct.getClaims().toMap());
                    } else {
                        this.log.error("Failed to find PCT with code: " + pctCode + " which is taken from permission object: " + permission.getDn());
                    }
                } else {
                    this.log.trace("PCT code is blank for RPT: " + rpt.getCode());
                }
            }
            String entity = ServerUtil.asJson(statusResponse);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private boolean isValid(UmaRPT p_rpt) {
        if (p_rpt != null) {
            p_rpt.checkExpired();
            return p_rpt.isValid();
        }
        return false;
    }

    private boolean isValid(UmaPermission permission) {
        if (permission != null) {
            permission.checkExpired();
            return permission.isValid();
        }
        return false;
    }

    private List<org.xdi.oxauth.model.uma.UmaPermission> buildStatusResponsePermissions(UmaRPT rpt) {
        List<UmaPermission> rptPermissions;
        ArrayList<org.xdi.oxauth.model.uma.UmaPermission> result = new ArrayList<org.xdi.oxauth.model.uma.UmaPermission>();
        if (rpt != null && (rptPermissions = this.rptService.getRptPermissions(rpt)) != null && !rptPermissions.isEmpty()) {
            for (UmaPermission permission : rptPermissions) {
                if (this.isValid(permission)) {
                    org.xdi.oxauth.model.uma.UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                    if (toAdd == null) continue;
                    result.add(toAdd);
                    continue;
                }
                this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}, rpt dn: {}", (Object)permission.getDn(), (Object)rpt.getDn());
            }
        }
        return result;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Not allowed")
    @ApiResponses(value={@ApiResponse(code=405, message="Introspection of RPT is not allowed by GET HTTP method.")})
    public Response requestRptStatusGet(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String rpt, @FormParam(value="token_type_hint") String tokenTypeHint) {
        throw new WebApplicationException(Response.status((int)405).entity((Object)"Introspection of RPT is not allowed by GET HTTP method.").build());
    }
}

