/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.python.google.common.base.Function;
import org.python.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.ClaimTokenFormatType;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.UmaPermissionList;
import org.xdi.oxauth.model.uma.UmaScopeType;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.UmaResource;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.authorization.UmaRPT;
import org.xdi.oxauth.uma.authorization.UmaWebException;
import org.xdi.oxauth.uma.service.UmaExpressionService;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaResourceService;
import org.xdi.oxauth.uma.service.UmaRptService;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Named
@Stateless
public class UmaValidationService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private TokenService tokenService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaRptService rptService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private UmaExpressionService expressionService;

    public AuthorizationGrant assertHasProtectionScope(String authorization) {
        return this.validateAuthorization(authorization, UmaScopeType.PROTECTION);
    }

    private AuthorizationGrant validateAuthorization(String authorization, UmaScopeType umaScopeType) {
        Set<String> scopes;
        AuthorizationGrant authorizationGrant;
        String token;
        this.log.trace("Validate authorization: {}", (Object)authorization);
        if (StringHelper.isEmpty((String)authorization)) {
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT);
        }
        if (StringHelper.isEmpty((String)(token = this.tokenService.getTokenFromAuthorizationParameter(authorization)))) {
            this.log.debug("Token is invalid");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT);
        }
        if ((authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token)) == null) {
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.ACCESS_DENIED);
        }
        if (!authorizationGrant.isValid()) {
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.INVALID_TOKEN);
        }
        if (!(scopes = authorizationGrant.getScopes()).contains(umaScopeType.getValue())) {
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.NOT_ACCEPTABLE, (IErrorType)UmaErrorResponseType.INVALID_CLIENT_SCOPE);
        }
        return authorizationGrant;
    }

    public UmaRPT validateRPT(String rptCode) {
        if (StringUtils.isNotBlank((String)rptCode)) {
            UmaRPT rpt = this.rptService.getRPTByCode(rptCode);
            if (rpt != null) {
                rpt.checkExpired();
                if (rpt.isValid()) {
                    return rpt;
                }
                this.log.error("RPT is not valid. Revoked: " + rpt.isRevoked() + ", Expired: " + rpt.isExpired() + ", rptCode: " + rptCode);
            } else {
                this.log.error("RPT is null, rptCode: " + rptCode);
            }
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RPT);
        }
        return null;
    }

    public void validatePermissions(List<UmaPermission> permissions) {
        for (UmaPermission permission : permissions) {
            this.validatePermission(permission);
        }
    }

    public void validatePermission(UmaPermission permission) {
        if (permission == null || "invalidated".equalsIgnoreCase(permission.getStatus())) {
            this.log.error("Permission is null or otherwise invalidated. Status: " + (permission != null ? permission.getStatus() : ""));
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET);
        }
        permission.checkExpired();
        if (!permission.isValid()) {
            this.log.error("Permission is not valid.");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.EXPIRED_TICKET);
        }
    }

    public void validatePermissions(UmaPermissionList permissions) {
        for (org.xdi.oxauth.model.uma.UmaPermission permission : permissions) {
            this.validatePermission(permission);
        }
    }

    public void validatePermission(org.xdi.oxauth.model.uma.UmaPermission permission) {
        String resourceId = permission.getResourceId();
        if (StringHelper.isEmpty((String)resourceId)) {
            this.log.error("Resource id is empty");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID);
        }
        try {
            UmaResource resource = this.resourceService.getResourceById(resourceId);
            if (resource == null) {
                this.log.error("Resource isn't registered or there are two resources with same Id");
                this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID);
                return;
            }
            List<String> scopeUrls = this.umaScopeService.getScopeIdsByDns(resource.getScopes());
            if (scopeUrls.containsAll(permission.getScopes())) {
                return;
            }
            this.log.error("At least one of the scope isn't registered");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SCOPE);
        }
        catch (EntryPersistenceException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        this.log.error("Resource isn't registered");
        this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID);
    }

    public void validateGrantType(String grantType) {
        this.log.trace("Validate grantType: {}", (Object)grantType);
        if (!GrantType.OXAUTH_UMA_TICKET.getValue().equals(grantType)) {
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID);
        }
    }

    public List<UmaPermission> validateTicket(String ticket) {
        List<UmaPermission> permissions;
        if (StringUtils.isBlank((String)ticket)) {
            this.log.error("Ticket is null or blank.");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET);
        }
        if ((permissions = this.permissionService.getPermissionsByTicket(ticket)) == null || permissions.isEmpty()) {
            this.log.error("Unable to find permissions registered for given ticket:" + ticket);
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET);
        }
        return permissions;
    }

    public List<UmaPermission> validateTicketWithRedirect(String ticket, String claimsRedirectUri, String state) {
        if (StringUtils.isBlank((String)ticket)) {
            this.log.error("Ticket is null or blank.");
            throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_TICKET, state);
        }
        List<UmaPermission> permissions = this.permissionService.getPermissionsByTicket(ticket);
        if (permissions == null || permissions.isEmpty()) {
            this.log.error("Unable to find permissions registered for given ticket:" + ticket);
            throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_TICKET, state);
        }
        return permissions;
    }

    public Jwt validateClaimToken(String claimToken, String claimTokenFormat) {
        if (StringUtils.isNotBlank((String)claimToken)) {
            if (!ClaimTokenFormatType.isValueValid((String)claimTokenFormat)) {
                this.log.error("claim_token_format is unsupported. Supported format is http://openid.net/specs/openid-connect-core-1_0.html#IDToken");
                this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN_FORMAT);
            }
            try {
                Jwt idToken = Jwt.parse((String)claimToken);
                if (idToken != null) {
                    if (ServerUtil.isTrue(this.appConfiguration.getUmaValidateClaimToken()) && !this.isIdTokenValid(idToken)) {
                        this.log.error("claim_token validation failed.");
                        this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN);
                    }
                    return idToken;
                }
            }
            catch (Exception e) {
                this.log.error("Failed to parse claim_token as valid id_token.", (Throwable)e);
            }
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN);
        } else if (StringUtils.isNotBlank((String)claimTokenFormat)) {
            this.log.error("claim_token is blank but claim_token_format is not blank. Both must be blank or both must be not blank");
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN);
        }
        return null;
    }

    public boolean isIdTokenValid(Jwt idToken) {
        try {
            String issuer = idToken.getClaims().getClaimAsString("iss");
            Date expiresAt = idToken.getClaims().getClaimAsDate("exp");
            Date now = new Date();
            if (now.after(expiresAt)) {
                this.log.error("ID Token is expired. (It is after " + now + ").");
                return false;
            }
            if (!issuer.equals(this.appConfiguration.getIssuer())) {
                this.log.error("ID Token issuer is invalid. Token issuer: " + issuer + ", server issuer: " + this.appConfiguration.getIssuer());
                return false;
            }
            String kid = idToken.getHeader().getClaimAsString("kid");
            String algorithm = idToken.getHeader().getClaimAsString("alg");
            RSAPublicKey publicKey = this.getPublicKey(kid);
            if (publicKey != null) {
                RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.fromString((String)algorithm), publicKey);
                boolean signature = rsaSigner.validate(idToken);
                if (signature) {
                    this.log.debug("ID Token is successfully validated.");
                    return true;
                }
                this.log.error("ID Token signature is invalid.");
            } else {
                this.log.error("Failed to get RSA public key.");
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("Failed to validate id_token. Message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private RSAPublicKey getPublicKey(String kid) {
        JSONWebKey key = this.webKeysConfiguration.getKey(kid);
        if (key != null) {
            switch (key.getKty()) {
                case RSA: {
                    return new RSAPublicKey(key.getN(), key.getE());
                }
            }
        }
        return null;
    }

    public UmaPCT validatePct(String pctCode) {
        if (StringUtils.isNotBlank((String)pctCode)) {
            UmaPCT pct = this.pctService.getByCode(pctCode);
            if (pct != null) {
                pct.checkExpired();
                if (pct.isValid()) {
                    this.log.trace("PCT is validated successfully, pct: " + pctCode);
                    return pct;
                }
                this.log.error("PCT is not valid. Revoked: " + pct.isRevoked() + ", Expired: " + pct.isExpired() + ", pctCode: " + pctCode);
            } else {
                this.log.error("Failed to find PCT with pctCode: " + pctCode);
            }
            this.errorResponseFactory.throwUmaWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.INVALID_PCT);
        }
        return null;
    }

    public Map<UmaScopeDescription, Boolean> validateScopes(String scope, List<UmaPermission> permissions) {
        Object[] scopesRequested = StringUtils.isNotBlank((String)(scope = ServerUtil.urlDecode(scope))) ? scope.split(" ") : new String[]{};
        HashMap<UmaScopeDescription, Boolean> result = new HashMap<UmaScopeDescription, Boolean>();
        if (ArrayUtils.isNotEmpty((Object[])scopesRequested)) {
            for (UmaScopeDescription s : this.umaScopeService.getScopesByIds(Arrays.asList(scopesRequested))) {
                result.put(s, true);
            }
        }
        for (UmaPermission permission : permissions) {
            for (UmaScopeDescription s : this.umaScopeService.getScopesByDns(permission.getScopeDns())) {
                result.put(s, false);
            }
        }
        if (result.isEmpty()) {
            this.log.error("There are no any scopes requested in give request.");
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_RESOURCE_SCOPE);
        }
        this.log.trace("CandidateGrantedScopes: " + Joiner.on((String)", ").join(Iterables.transform(result.keySet(), (Function)new Function<UmaScopeDescription, String>(){

            public String apply(UmaScopeDescription umaScopeDescription) {
                return umaScopeDescription.getId();
            }
        })));
        return result;
    }

    public void validateScopeExpression(String scopeExpression) {
        if (StringUtils.isNotBlank((String)scopeExpression) && !this.expressionService.isExpressionValid(scopeExpression)) {
            this.log.error("Scope expression is invalid. Expression: " + scopeExpression);
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_RESOURCE_SCOPE);
        }
    }

    public Client validateClientAndClaimsRedirectUri(String clientId, String claimsRedirectUri, String state) {
        if (StringUtils.isBlank((String)clientId)) {
            this.log.error("Invalid clientId: {}", (Object)clientId);
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLIENT_ID);
        }
        Client client = this.clientService.getClient(clientId);
        if (client == null) {
            this.log.error("Failed to find client with client_id: {}", (Object)clientId);
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLIENT_ID);
        }
        if (StringUtils.isNotBlank((String)claimsRedirectUri)) {
            if (ArrayUtils.isEmpty((Object[])client.getClaimRedirectUris())) {
                this.log.error("Client does not have claims_redirect_uri specified, clientId: " + clientId);
                throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI);
            }
            String equalRedirectUri = this.getEqualRedirectUri(claimsRedirectUri, client.getClaimRedirectUris());
            if (equalRedirectUri != null) {
                this.log.trace("Found match for claims_redirect_uri : " + equalRedirectUri);
                return client;
            }
            this.log.trace("Failed to find match for claims_redirect_uri : " + claimsRedirectUri + ", client claimRedirectUris: " + Arrays.toString(client.getClaimRedirectUris()));
        } else {
            this.log.trace("claims_redirect_uri is blank");
            if (client.getClaimRedirectUris() != null && client.getClaimRedirectUris().length == 1) {
                this.log.trace("claims_redirect_uri is blank and only one claims_redirect_uri is registered.");
                return client;
            }
        }
        if (StringUtils.isBlank((String)claimsRedirectUri)) {
            this.log.error("claims_redirect_uri is blank and there is none or more then one registered claims_redirect_uri for clientId: " + clientId);
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI);
        }
        throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI, state);
    }

    private String getEqualRedirectUri(String redirectUri, String[] clientRedirectUris) {
        String redirectUriWithoutParams = RedirectionUriService.uriWithoutParams(redirectUri);
        for (String uri : clientRedirectUris) {
            this.log.debug("Comparing {} == {}", (Object)uri, (Object)redirectUri);
            if (uri.equals(redirectUri)) {
                return redirectUri;
            }
            String uriWithoutParams = RedirectionUriService.uriWithoutParams(uri);
            Map<String, String> params = RedirectionUriService.getParams(uri);
            if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || RedirectionUriService.getParams(redirectUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !RedirectionUriService.compareParams(redirectUri, uri))) continue;
            return redirectUri;
        }
        return null;
    }

    public String[] validatesGatheringScriptNames(String scriptNamesAsString, String claimsRedirectUri, String state) {
        Object[] scriptNames;
        if (StringUtils.isNotBlank((String)scriptNamesAsString) && ArrayUtils.isNotEmpty((Object[])(scriptNames = scriptNamesAsString.split(" ")))) {
            return scriptNames;
        }
        throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_GATHERING_SCRIPT_NAME, state);
    }

    public void validateRestrictedByClient(String patClientDn, String rsId) {
        List clients;
        if (ServerUtil.isTrue(this.appConfiguration.getUmaRestrictResourceToAssociatedClient()) && !(clients = this.resourceService.getResourceById(rsId).getClients()).contains(patClientDn)) {
            this.log.error("Access to resource is denied because resource associated client does not match PAT client (it can be switched off if set umaRestrictResourceToAssociatedClient oxauth configuration property to false). Associated clients: " + clients + ", PAT client: " + patClientDn);
            throw new UmaWebException(Response.Status.FORBIDDEN, this.errorResponseFactory, UmaErrorResponseType.ACCESS_DENIED);
        }
    }

    public void validateResource(org.xdi.oxauth.model.uma.UmaResource resource) {
        this.validateScopeExpression(resource.getScopeExpression());
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(resource.getScopes());
        if (scopeDNs.isEmpty() && StringUtils.isBlank((String)resource.getScopeExpression())) {
            this.log.error("Invalid resource. Both `scope` and `scope_expression` are blank.");
            throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_RESOURCE_SCOPE);
        }
    }
}

