/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.UmaTokenResponse;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.security.Identity;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.external.ExternalUmaRptPolicyService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.uma.authorization.Claims;
import org.xdi.oxauth.uma.authorization.UmaAuthorizationContext;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.authorization.UmaRPT;
import org.xdi.oxauth.uma.authorization.UmaScriptByScope;
import org.xdi.oxauth.uma.authorization.UmaWebException;
import org.xdi.oxauth.uma.service.UmaExpressionService;
import org.xdi.oxauth.uma.service.UmaNeedsInfoService;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaRptService;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.oxauth.uma.service.UmaValidationService;
import org.xdi.oxauth.util.ServerUtil;

@Named
@Stateless
public class UmaTokenService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private ClientService clientService;
    @Inject
    private TokenService tokenService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private UmaNeedsInfoService umaNeedsInfoService;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private UmaExpressionService expressionService;

    public Response requestRpt(String grantType, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String scope, HttpServletRequest httpRequest) {
        try {
            boolean upgraded;
            this.log.trace("requestRpt grant_type: {}, ticket: {}, claim_token: {}, claim_token_format: {}, pct: {}, rpt: {}, scope: {}", new Object[]{grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope});
            this.umaValidationService.validateGrantType(grantType);
            List<UmaPermission> permissions = this.umaValidationService.validateTicket(ticket);
            Jwt idToken = this.umaValidationService.validateClaimToken(claimToken, claimTokenFormat);
            UmaPCT pct = this.umaValidationService.validatePct(pctCode);
            UmaRPT rpt = this.umaValidationService.validateRPT(rptCode);
            Map<UmaScopeDescription, Boolean> scopes = this.umaValidationService.validateScopes(scope, permissions);
            Client client = this.identity.getSessionClient().getClient();
            if (client != null && client.isDisabled()) {
                throw new UmaWebException(Response.Status.FORBIDDEN, this.errorResponseFactory, UmaErrorResponseType.DISABLED_CLIENT);
            }
            Claims claims = new Claims(idToken, pct = this.pctService.updateClaims(pct, idToken, client.getClientId(), permissions), claimToken);
            Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap = this.umaNeedsInfoService.checkNeedsInfo(claims, scopes, permissions, pct, httpRequest, client);
            if (!scriptMap.isEmpty()) {
                this.expressionService.evaluate(scriptMap, permissions);
            } else {
                this.log.warn("There are no any policies that protects scopes. Scopes: " + UmaScopeService.asString(scopes.keySet()) + ". Configuration property umaGrantAccessIfNoPolicies: " + this.appConfiguration.getUmaGrantAccessIfNoPolicies());
                if (this.appConfiguration.getUmaGrantAccessIfNoPolicies() != null && this.appConfiguration.getUmaGrantAccessIfNoPolicies().booleanValue()) {
                    this.log.warn("Access granted because there are no any protection. Make sure it is intentional behavior.");
                } else {
                    this.log.warn("Access denied because there are no any protection. Make sure it is intentional behavior.");
                    throw new UmaWebException(Response.Status.FORBIDDEN, this.errorResponseFactory, UmaErrorResponseType.FORBIDDEN_BY_POLICY);
                }
            }
            this.log.trace("Access granted.");
            this.updatePermissionsWithClientRequestedScope(permissions, scopes);
            this.addPctToPermissions(permissions, pct);
            if (rpt == null) {
                rpt = this.rptService.createRPTAndPersist(client, permissions);
                upgraded = false;
            } else {
                this.rptService.addPermissionToRPT(rpt, permissions);
                upgraded = true;
            }
            UmaTokenResponse response = new UmaTokenResponse();
            response.setAccessToken(rpt.getCode());
            response.setUpgraded(Boolean.valueOf(upgraded));
            response.setTokenType("Bearer");
            response.setPct(pct.getCode());
            return Response.ok((Object)ServerUtil.asJson(response)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            this.log.error("Failed to handle request to UMA Token Endpoint.");
            throw new UmaWebException(Response.Status.INTERNAL_SERVER_ERROR, this.errorResponseFactory, UmaErrorResponseType.SERVER_ERROR);
        }
    }

    private void addPctToPermissions(List<UmaPermission> permissions, UmaPCT pct) {
        for (UmaPermission p : permissions) {
            p.getAttributes().put("pct", pct.getCode());
            this.permissionService.mergeSilently(p);
        }
    }

    private void updatePermissionsWithClientRequestedScope(List<UmaPermission> permissions, Map<UmaScopeDescription, Boolean> scopes) {
        this.log.trace("Updating permissions with requested scopes ...");
        for (UmaPermission permission : permissions) {
            HashSet<String> scopeDns = new HashSet<String>(permission.getScopeDns());
            for (Map.Entry<UmaScopeDescription, Boolean> entry : scopes.entrySet()) {
                this.log.trace("Updating permissions with scope: " + entry.getKey().getId() + ", isRequestedScope: " + entry.getValue() + ", permisson: " + permission.getDn());
                scopeDns.add(entry.getKey().getDn());
            }
            permission.setScopeDns(new ArrayList(scopeDns));
        }
    }
}

