/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.uma.authorization.UmaWebException;

@Stateless
@Named(value="umaScopeService")
public class UmaScopeService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private InumService inumService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;

    public List<UmaScopeDescription> getAllScopes() {
        try {
            return this.ldapEntryManager.findEntries(this.baseDn(), UmaScopeDescription.class, Filter.createPresenceFilter((String)"inum"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public UmaScopeDescription getScope(String scopeId) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxId=%s)", scopeId));
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), UmaScopeDescription.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one UMA scope, id: {}", (Object)scopeId);
                    for (UmaScopeDescription s : entries) {
                        this.log.error("Scope, Id: {}, dn: {}", (Object)s.getId(), (Object)s.getDn());
                    }
                }
                return (UmaScopeDescription)entries.get(0);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean persist(UmaScopeDescription scope) {
        try {
            if (StringUtils.isBlank((String)scope.getDn())) {
                scope.setDn(String.format("inum=%s,%s", scope.getInum(), this.baseDn()));
            }
            this.ldapEntryManager.persist((Object)scope);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<String> getScopeDNsByIdsAndAddToLdapIfNeeded(List<String> scopeIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (UmaScopeDescription scope : this.getScopesByIds(scopeIds)) {
            result.add(scope.getDn());
        }
        return result;
    }

    public List<UmaScopeDescription> getScopesByDns(List<String> scopeDns) {
        ArrayList<UmaScopeDescription> result = new ArrayList<UmaScopeDescription>();
        try {
            if (scopeDns != null && !scopeDns.isEmpty()) {
                for (String dn : scopeDns) {
                    UmaScopeDescription scopeDescription = (UmaScopeDescription)this.ldapEntryManager.find(UmaScopeDescription.class, (Object)dn);
                    if (scopeDescription != null) {
                        result.add(scopeDescription);
                        continue;
                    }
                    this.log.error("Failed to load UMA scope with dn: {}", (Object)dn);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<String> getScopeIdsByDns(List<String> scopeDns) {
        return this.getScopeIds(this.getScopesByDns(scopeDns));
    }

    public List<String> getScopeIds(List<UmaScopeDescription> scopes) {
        ArrayList<String> result = new ArrayList<String>();
        if (scopes != null && !scopes.isEmpty()) {
            for (UmaScopeDescription scope : scopes) {
                result.add(scope.getId());
            }
        }
        return result;
    }

    public List<UmaScopeDescription> getScopesByIds(List<String> scopeIds) {
        ArrayList<UmaScopeDescription> result = new ArrayList<UmaScopeDescription>();
        if (scopeIds != null && !scopeIds.isEmpty()) {
            ArrayList<String> notInLdap = new ArrayList<String>(scopeIds);
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), UmaScopeDescription.class, this.createAnyFilterByIds(scopeIds));
            if (entries != null) {
                result.addAll(entries);
                for (UmaScopeDescription scope : entries) {
                    notInLdap.remove(scope.getId());
                }
            }
            if (!notInLdap.isEmpty()) {
                for (String scopeId : notInLdap) {
                    result.add(this.addScope(scopeId));
                }
            }
        }
        return result;
    }

    public UmaScopeDescription addScope(String scopeId) {
        Boolean addAutomatically = this.appConfiguration.getUmaAddScopesAutomatically();
        if (addAutomatically != null && addAutomatically.booleanValue()) {
            String inum = this.inumService.generateInum();
            UmaScopeDescription newScope = new UmaScopeDescription();
            newScope.setInum(inum);
            newScope.setDisplayName(scopeId);
            newScope.setId(scopeId);
            boolean persisted = this.persist(newScope);
            if (persisted) {
                return newScope;
            }
            this.log.error("Failed to persist scope, id:{}" + scopeId);
        }
        throw new UmaWebException(Response.Status.BAD_REQUEST, this.errorResponseFactory, UmaErrorResponseType.INVALID_RESOURCE_SCOPE);
    }

    public String getScopeEndpoint() {
        return this.appConfiguration.getBaseEndpoint() + "/uma/scopes";
    }

    private Filter createAnyFilterByIds(List<String> scopeIds) {
        try {
            if (scopeIds != null && !scopeIds.isEmpty()) {
                StringBuilder sb = new StringBuilder("(|");
                for (String url : scopeIds) {
                    sb.append("(");
                    sb.append("oxId=");
                    sb.append(url);
                    sb.append(")");
                }
                sb.append(")");
                String filterAsString = sb.toString();
                this.log.trace("Uma scope ids: " + scopeIds + ", ldapFilter: " + filterAsString);
                return Filter.create((String)filterAsString);
            }
        }
        catch (LDAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String baseDn() {
        return String.format("ou=scopes,%s", this.staticConfiguration.getBaseDn().getUmaBase());
    }

    public static String asString(Collection<UmaScopeDescription> scopes) {
        String result = "";
        for (UmaScopeDescription scope : scopes) {
            result = result + scope.getId() + " ";
        }
        return result.trim();
    }
}

