/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import com.google.common.base.Preconditions;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.StaticUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.JwtSigner;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.authorization.UmaRPT;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.INumGenerator;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class UmaRptService {
    private static final String ORGUNIT_OF_RPT = "uma_rpt";
    public static final int DEFAULT_RPT_LIFETIME = 3600;
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;

    public static String getDn(String clientDn, String uniqueIdentifier) {
        return String.format("uniqueIdentifier=%s,%s", uniqueIdentifier, UmaRptService.branchDn(clientDn));
    }

    public static String branchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RPT, clientDn);
    }

    public void persist(UmaRPT rpt) {
        try {
            Preconditions.checkNotNull((Object)rpt.getClientId());
            Client client = this.clientService.getClient(rpt.getClientId());
            this.addBranchIfNeeded(client.getDn());
            String id = UUID.randomUUID().toString();
            rpt.setId(id);
            rpt.setDn(UmaRptService.getDn(client.getDn(), id));
            this.ldapEntryManager.persist((Object)rpt);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UmaRPT getRPTByCode(String rptCode) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxAuthTokenCode=%s)", rptCode));
            String baseDn = this.staticConfiguration.getBaseDn().getClients();
            List entries = this.ldapEntryManager.findEntries(baseDn, UmaRPT.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (UmaRPT)entries.get(0);
            }
            this.log.error("Failed to find RPT by code: " + rptCode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void deleteByCode(String rptCode) {
        try {
            UmaRPT t = this.getRPTByCode(rptCode);
            if (t != null) {
                this.ldapEntryManager.remove((Object)t);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup(final Date now) {
        BatchOperation<UmaRPT> rptBatchService = new BatchOperation<UmaRPT>(this.ldapEntryManager){

            protected List<UmaRPT> getChunkOrNull(int chunkSize) {
                return UmaRptService.this.ldapEntryManager.findEntries(UmaRptService.this.staticConfiguration.getBaseDn().getClients(), UmaRPT.class, this.getFilter(), SearchScope.SUB, null, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<UmaRPT> entries) {
                for (UmaRPT p : entries) {
                    try {
                        UmaRptService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        UmaRptService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                try {
                    return Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)now)));
                }
                catch (LDAPException e) {
                    UmaRptService.this.log.trace(e.getMessage(), (Throwable)e);
                    return Filter.createPresenceFilter((String)"oxAuthExpiration");
                }
            }
        };
        rptBatchService.iterateAllByChunks(25);
    }

    public void addPermissionToRPT(UmaRPT rpt, Collection<UmaPermission> permissions) {
        this.addPermissionToRPT(rpt, permissions.toArray(new UmaPermission[permissions.size()]));
    }

    public void addPermissionToRPT(UmaRPT rpt, UmaPermission ... permission) {
        if (ArrayUtils.isEmpty((Object[])permission)) {
            return;
        }
        List<String> permissions = UmaRptService.getPermissionDns(Arrays.asList(permission));
        if (rpt.getPermissions() != null) {
            permissions.addAll(rpt.getPermissions());
        }
        rpt.setPermissions(permissions);
        try {
            this.ldapEntryManager.merge((Object)rpt);
            this.log.trace("Persisted RPT: " + rpt);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getPermissionDns(Collection<UmaPermission> permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (permissions != null) {
            for (UmaPermission p : permissions) {
                result.add(p.getDn());
            }
        }
        return result;
    }

    public List<UmaPermission> getRptPermissions(UmaRPT p_rpt) {
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        try {
            if (p_rpt != null && p_rpt.getPermissions() != null) {
                List<String> permissionDns = p_rpt.getPermissions();
                for (String permissionDn : permissionDns) {
                    UmaPermission permissionObject = (UmaPermission)this.ldapEntryManager.find(UmaPermission.class, (Object)permissionDn);
                    if (permissionObject == null) continue;
                    result.add(permissionObject);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Date rptExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaRptLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    public UmaRPT createRPTAndPersist(Client client, List<UmaPermission> permissions) {
        try {
            Date creationDate = new Date();
            Date expirationDate = this.rptExpirationDate();
            String code = client.isRptAsJwt() ? this.createRptJwt(client, permissions, creationDate, expirationDate) : UUID.randomUUID().toString() + "_" + INumGenerator.generate((int)8);
            UmaRPT rpt = new UmaRPT(code, creationDate, expirationDate, null, client.getClientId());
            rpt.setPermissions(UmaRptService.getPermissionDns(permissions));
            this.persist(rpt);
            return rpt;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to generate RPT, clientId: " + client.getClientId(), e);
        }
    }

    private String createRptJwt(Client client, List<UmaPermission> permissions, Date creationDate, Date expirationDate) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setClaim("client_id", client.getClientId());
        jwt.getClaims().setExpirationTime(expirationDate);
        jwt.getClaims().setIssuedAt(creationDate);
        jwt.getClaims().setAudience(client.getClientId());
        if (permissions != null && !permissions.isEmpty()) {
            String pctCode = (String)permissions.iterator().next().getAttributes().get("pct");
            if (StringHelper.isNotEmpty((String)pctCode)) {
                UmaPCT pct = this.pctService.getByCode(pctCode);
                if (pct != null) {
                    jwt.getClaims().setClaim("pct_claims", pct.getClaims().toJsonObject());
                } else {
                    this.log.error("Failed to find PCT with code: " + pctCode + " which is taken from permission object: " + permissions.iterator().next().getDn());
                }
            }
            jwt.getClaims().setClaim("permissions", this.buildPermissionsJSONObject(permissions));
        }
        return jwtSigner.sign().toString();
    }

    public JSONArray buildPermissionsJSONObject(List<UmaPermission> permissions) throws IOException, JSONException {
        ArrayList<org.xdi.oxauth.model.uma.UmaPermission> result = new ArrayList<org.xdi.oxauth.model.uma.UmaPermission>();
        for (UmaPermission permission : permissions) {
            permission.checkExpired();
            permission.isValid();
            if (permission.isValid()) {
                org.xdi.oxauth.model.uma.UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                if (toAdd == null) continue;
                result.add(toAdd);
                continue;
            }
            this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}", (Object)permission.getDn());
        }
        String json = ServerUtil.asJson(result);
        return new JSONArray(json);
    }

    public UmaPermission getPermissionFromRPTByResourceId(UmaRPT rpt, String resourceId) {
        try {
            if (Util.allNotBlank((String[])new String[]{resourceId})) {
                for (UmaPermission permission : this.getRptPermissions(rpt)) {
                    if (!resourceId.equals(permission.getResourceId())) continue;
                    return permission;
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RPT);
        branch.setDn(UmaRptService.branchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (!this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, UmaRptService.branchDn(clientDn));
    }
}

