/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import com.google.common.base.Preconditions;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.uma.persistence.UmaResource;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class UmaResourceService {
    private static final int RESOURCE_CACHE_EXPIRATION_IN_SECONDS = 120;
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private CacheService cacheService;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("resources");
        branch.setDn(this.getDnForResource(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addResource(UmaResource resource) {
        this.validate(resource);
        this.ldapEntryManager.persist((Object)resource);
        this.putInCache(resource);
    }

    public void validate(UmaResource resource) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)resource.getName()), (Object)"Name is required for resource.");
        Preconditions.checkArgument((resource.getScopes() != null && !resource.getScopes().isEmpty() || StringUtils.isNotBlank((String)resource.getScopeExpression()) ? 1 : 0) != 0, (Object)"Scope must be specified for resource.");
        Preconditions.checkState((!resource.isExpired() ? 1 : 0) != 0, (Object)"UMA Resource expired. It must not be expired.");
        this.prepareBranch();
    }

    public void updateResource(UmaResource resource) {
        this.validate(resource);
        this.ldapEntryManager.merge((Object)resource);
    }

    public void remove(UmaResource resource) {
        this.ldapEntryManager.remove((Object)resource);
    }

    public void remove(String rsid) {
        this.ldapEntryManager.remove((Object)this.getResourceById(rsid));
    }

    public void remove(List<UmaResource> resources) {
        for (UmaResource resource : resources) {
            this.remove(resource);
        }
    }

    public List<UmaResource> getResourcesByAssociatedClient(String associatedClientDn) {
        try {
            this.prepareBranch();
            if (StringUtils.isNotBlank((String)associatedClientDn)) {
                Filter filter = Filter.create((String)String.format("&(oxAssociatedClient=%s)", associatedClientDn));
                return this.ldapEntryManager.findEntries(this.getBaseDnForResource(), UmaResource.class, filter);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<UmaResource> findResources(UmaResource resource) {
        return this.ldapEntryManager.findEntries((Object)resource);
    }

    public boolean containsResource(UmaResource resource) {
        return this.ldapEntryManager.contains((Object)resource);
    }

    public Set<UmaResource> getResources(Set<String> ids) {
        HashSet<UmaResource> result = new HashSet<UmaResource>();
        if (ids != null) {
            for (String id : ids) {
                UmaResource resource = this.getResourceById(id);
                if (resource != null) {
                    result.add(resource);
                    continue;
                }
                this.log.error("Failed to find resource by id: " + id);
            }
        }
        return result;
    }

    public UmaResource getResourceById(String id) {
        UmaResource fromCache = this.fromCache(this.getDnForResource(id));
        if (fromCache != null) {
            this.log.trace("UMA Resource from cache, id: " + id);
            return fromCache;
        }
        this.prepareBranch();
        UmaResource ldapResource = new UmaResource();
        ldapResource.setDn(this.getBaseDnForResource());
        ldapResource.setId(id);
        List<UmaResource> result = this.findResources(ldapResource);
        if (result.size() == 0) {
            this.log.error("Failed to find resource set with id: " + id);
            this.errorResponseFactory.throwUmaNotFoundException();
        } else if (result.size() > 1) {
            this.log.error("Multiple resource sets found with given id: " + id);
            this.errorResponseFactory.throwUmaInternalErrorException();
        }
        return result.get(0);
    }

    private void prepareBranch() {
        if (!this.ldapEntryManager.contains(SimpleBranch.class, this.getDnForResource(null))) {
            this.addBranch();
        }
    }

    public UmaResource getResourceByDn(String dn) {
        UmaResource fromCache = this.fromCache(dn);
        if (fromCache != null) {
            return fromCache;
        }
        return (UmaResource)this.ldapEntryManager.find(UmaResource.class, (Object)dn);
    }

    public String getDnForResource(String oxId) {
        if (StringHelper.isEmpty((String)oxId)) {
            return this.getBaseDnForResource();
        }
        return String.format("oxId=%s,%s", oxId, this.getBaseDnForResource());
    }

    public String getBaseDnForResource() {
        String umaBaseDn = this.staticConfiguration.getBaseDn().getUmaBase();
        return String.format("ou=resources,%s", umaBaseDn);
    }

    private void putInCache(UmaResource resource) {
        if (resource == null) {
            return;
        }
        try {
            this.cacheService.put(Integer.toString(120), resource.getDn(), (Object)resource, true);
        }
        catch (Exception e) {
            this.log.error("Failed to put client in cache, client:" + resource, (Throwable)e);
        }
    }

    private UmaResource fromCache(String dn) {
        try {
            return (UmaResource)this.cacheService.get(null, dn);
        }
        catch (Exception e) {
            this.log.error("Failed to fetch client from cache, dn: " + dn, (Throwable)e);
            return null;
        }
    }

    public boolean removeFromCache(UmaResource resource) {
        try {
            this.cacheService.remove(null, resource.getDn());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void cleanup(Date now) {
        this.prepareBranch();
        final Filter expirationFilter = Filter.createLessOrEqualFilter((String)"oxAuthExpiration", (String)StaticUtils.encodeGeneralizedTime((Date)now));
        BatchOperation<UmaResource> batchService = new BatchOperation<UmaResource>(this.ldapEntryManager){

            protected List<UmaResource> getChunkOrNull(int chunkSize) {
                return UmaResourceService.this.ldapEntryManager.findEntries(UmaResourceService.this.getBaseDnForResource(), UmaResource.class, expirationFilter, SearchScope.SUB, new String[]{""}, (BatchOperation)this, 0, 0, 25);
            }

            public void performAction(List<UmaResource> entries) {
                for (UmaResource p : entries) {
                    try {
                        UmaResourceService.this.remove(p);
                    }
                    catch (Exception e) {
                        UmaResourceService.this.log.error("Failed to remove UMA resource on cleaning.", (Throwable)e);
                    }
                }
            }
        };
        batchService.iterateAllByChunks(25);
    }
}

